/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.web.mbean.util;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import net.sf.ahtutils.controller.interfaces.mbean.JiraConfig;
import net.sf.ahtutils.exception.ejb.UtilsNotFoundException;
import net.sf.ahtutils.interfaces.facade.UtilsFacade;
import net.sf.ahtutils.model.interfaces.UtilsProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractJiraBean
implements Serializable,
JiraConfig {
    static final Logger logger = LoggerFactory.getLogger(AbstractJiraBean.class);
    private static final long serialVersionUID = 1L;
    protected String jiraHost;
    protected String jiraScriptPath;
    protected Map<String, String> collectorId = new Hashtable<String, String>();

    public <T extends UtilsProperty> void init(UtilsFacade fUtils, Class<T> cl, String[] collectorKeys) throws UtilsNotFoundException {
        this.jiraHost = fUtils.valueStringForKey(cl, JiraConfig.Code.jiraHost.toString(), null);
        this.jiraScriptPath = fUtils.valueStringForKey(cl, JiraConfig.Code.jiraScriptPath.toString(), null);
        for (String key : collectorKeys) {
            this.collectorId.put(key, fUtils.valueStringForKey(cl, JiraConfig.Code.jiraCollector.toString() + key, null));
        }
    }

    public String getJiraHost() {
        return this.jiraHost;
    }

    public String getJiraScriptPath() {
        return this.jiraScriptPath;
    }

    public Map<String, String> getCollectorId() {
        return this.collectorId;
    }
}

