/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.web.mbean.util;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import net.sf.ahtutils.jsf.menu.MenuFactory;
import net.sf.ahtutils.xml.navigation.Breadcrumb;
import net.sf.ahtutils.xml.navigation.Menu;
import net.sf.ahtutils.xml.navigation.MenuItem;
import net.sf.exlp.util.xml.JaxbUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMenuBean
implements Serializable {
    static final Logger logger = LoggerFactory.getLogger(AbstractMenuBean.class);
    private static final long serialVersionUID = 1L;
    protected static final String rootMain = "root";
    protected Map<String, Menu> mapMenu;
    protected Map<String, MenuItem> mapSub;
    protected Map<String, Breadcrumb> mapBreadcrumb;
    protected Map<String, Boolean> mapViewAllowed;

    public void initMaps() throws FileNotFoundException {
        this.mapMenu = new Hashtable<String, Menu>();
        this.mapSub = new Hashtable<String, MenuItem>();
        this.mapBreadcrumb = new Hashtable<String, Breadcrumb>();
    }

    public void clear() {
        this.mapMenu.clear();
        this.mapSub.clear();
        this.mapBreadcrumb.clear();
        this.mapViewAllowed = null;
    }

    protected void buildViewAllowedMap() {
        logger.warn("This should never been called here. A @Override in extended class is required");
    }

    protected Menu menu(MenuFactory mf, String code) {
        return this.menu(mf, code, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Menu menu(MenuFactory mf, String code, boolean loggedIn) {
        this.buildViewAllowedMap();
        if (code == null || code.length() == 0) {
            code = rootMain;
        }
        if (!this.mapMenu.containsKey(code)) {
            MenuFactory menuFactory = mf;
            synchronized (menuFactory) {
                this.mapMenu.put(code, mf.build(this.mapViewAllowed, code, loggedIn));
            }
        }
        return this.mapMenu.get(code);
    }

    public Breadcrumb breadcrumb(MenuFactory mf, String code) {
        return this.breadcrumb(mf, false, code, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Breadcrumb breadcrumb(MenuFactory mf, boolean withRoot, String code, boolean withFirst, boolean withChilds) {
        if (!this.mapBreadcrumb.containsKey(code)) {
            MenuFactory menuFactory = mf;
            synchronized (menuFactory) {
                if (!this.mapMenu.containsKey(code)) {
                    this.menu(mf, code);
                }
                Breadcrumb bOrig = mf.breadcrumb(withRoot, code);
                Breadcrumb bClone = new Breadcrumb();
                int startIndex = 0;
                if (bOrig.getMenuItem().size() > 1 && !withFirst) {
                    startIndex = 1;
                }
                for (int i = startIndex; i < bOrig.getMenuItem().size(); ++i) {
                    MenuItem miOrig = (MenuItem)bOrig.getMenuItem().get(i);
                    MenuItem miClone = new MenuItem();
                    miClone.setName(miOrig.getName());
                    miClone.setHref(miOrig.getHref());
                    miClone.setCode(miOrig.getCode());
                    bClone.getMenuItem().add(miClone);
                }
                if (withChilds) {
                    for (MenuItem mi : bClone.getMenuItem()) {
                        String parentCode = mf.getParent(mi.getCode());
                        for (MenuItem subOrig : this.sub(mf, parentCode).getMenuItem()) {
                            MenuItem subClone = new MenuItem();
                            subClone.setName(subOrig.getName());
                            subClone.setHref(subOrig.getHref());
                            mi.getMenuItem().add(subClone);
                        }
                    }
                }
                this.mapBreadcrumb.put(code, bClone);
                JaxbUtil.info((Object)this.mapBreadcrumb.get(code));
            }
        }
        return this.mapBreadcrumb.get(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem sub(MenuFactory mf, String code) {
        if (!this.mapSub.containsKey(code)) {
            MenuFactory menuFactory = mf;
            synchronized (menuFactory) {
                if (!this.mapMenu.containsKey(code)) {
                    this.menu(mf, code);
                }
                Menu m = this.mapMenu.get(code);
                this.mapSub.put(code, mf.subMenu(m, code));
            }
        }
        return this.mapSub.get(code);
    }
}

