/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.web.mbean.util;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.List;
import net.sf.ahtutils.msgbundle.TranslationFactory;
import net.sf.ahtutils.msgbundle.TranslationMap;
import net.sf.exlp.util.xml.JaxbUtil;
import net.sf.exlp.xml.io.Dir;
import net.sf.exlp.xml.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractTranslationBean
implements Serializable {
    static final Logger logger = LoggerFactory.getLogger(AbstractTranslationBean.class);
    private static final long serialVersionUID = 1L;
    private TranslationMap tm;
    protected List<String> langKeys;

    public void initMap(ClassLoader cl, String fXml) throws FileNotFoundException {
        logger.info("Init " + TranslationMap.class.getSimpleName() + " with " + fXml);
        Dir dir = (Dir)JaxbUtil.loadJAXB((ClassLoader)cl, (String)fXml, Dir.class);
        TranslationFactory tFactory = new TranslationFactory();
        for (File f : dir.getFile()) {
            tFactory.add(cl, dir.getName() + "/" + f.getName());
        }
        this.tm = tFactory.gettMap();
        this.langKeys = this.tm.getLangKeys();
    }

    public void overrideLangKeys(String ... key) {
        this.langKeys.clear();
        for (String s : key) {
            this.langKeys.add(s);
        }
    }

    public String get(String lang, String key) {
        return this.tm.translate(lang, key);
    }

    public List<String> getLangKeys() {
        return this.langKeys;
    }
}

