/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.web.rest;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestEasyPreemptiveClientExecutor {
    static final Logger logger = LoggerFactory.getLogger(RestEasyPreemptiveClientExecutor.class);

    private RestEasyPreemptiveClientExecutor() {
    }

    public static ClientExecutor factory(String username, String password) throws UnauthorizedException {
        RestEasyPreemptiveClientExecutor f = new RestEasyPreemptiveClientExecutor();
        DefaultHttpClient httpClient = new DefaultHttpClient();
        RestEasyPreemptiveClientExecutor restEasyPreemptiveClientExecutor = f;
        restEasyPreemptiveClientExecutor.getClass();
        httpClient.addRequestInterceptor((HttpRequestInterceptor)restEasyPreemptiveClientExecutor.new PreemptiveAuthInterceptor(username, password), 0);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor((HttpClient)httpClient);
        return clientExecutor;
    }

    public class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        private String username;
        private String password;

        public PreemptiveAuthInterceptor(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            authState.setAuthScope(AuthScope.ANY);
            authState.setCredentials((Credentials)new UsernamePasswordCredentials(this.username, this.password));
            authState.setAuthScheme((AuthScheme)new BasicScheme());
        }
    }
}

