/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.web.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemServlet
extends HttpServlet {
    static final Logger logger = LoggerFactory.getLogger(FileSystemServlet.class);
    private static final long serialVersionUID = 1L;
    protected static final int DEFAULT_BUFFER_SIZE = 10240;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(File f, String contentType, HttpServletResponse response) throws IOException {
        response.reset();
        response.setBufferSize(10240);
        response.setContentType(contentType);
        response.setHeader("Content-Length", String.valueOf(f.length()));
        response.setHeader("Content-Disposition", "inline; filename=\"" + f.getName() + "\"");
        BufferedInputStream input = null;
        BufferedOutputStream output = null;
        try {
            int length;
            input = new BufferedInputStream(new FileInputStream(f), 10240);
            output = new BufferedOutputStream((OutputStream)response.getOutputStream(), 10240);
            byte[] buffer = new byte[10240];
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
            this.close(output);
            this.close(input);
        }
        catch (Throwable throwable) {
            this.close(output);
            this.close(input);
            throw throwable;
        }
    }

    protected void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

