/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ahtutils.test;

import java.io.File;

public class MavenArtifactResolver {
    private static final String LOCAL_MAVEN_REPO = System.getProperty("maven.repo.local") != null ? System.getProperty("maven.repo.local") : System.getProperty("user.home") + File.separatorChar + ".m2" + File.separatorChar + "repository";

    public static File resolve(String groupId, String artifactId, String version, String suffix) {
        return MavenArtifactResolver.resolve(groupId, artifactId, version, null, suffix);
    }

    public static File resolve(String groupId, String artifactId, String version, String classifier, String suffix) {
        return new File(LOCAL_MAVEN_REPO + File.separatorChar + groupId.replace(".", File.separator) + File.separatorChar + artifactId + File.separatorChar + version + File.separatorChar + artifactId + "-" + version + (classifier != null ? "-" + classifier : "") + "." + suffix);
    }

    public static File resolve(String qualifiedArtifactId) {
        return MavenArtifactResolver.resolve(qualifiedArtifactId, "jar");
    }

    public static File resolve(String qualifiedArtifactId, String suffix) {
        String[] segments = qualifiedArtifactId.split(":");
        if (segments.length == 3) {
            return MavenArtifactResolver.resolve(segments[0], segments[1], segments[2], suffix);
        }
        if (segments.length == 4) {
            return MavenArtifactResolver.resolve(segments[0], segments[1], segments[2], segments[3], suffix);
        }
        throw new IllegalArgumentException("Invalid qualified artifactId syntax: " + qualifiedArtifactId);
    }

    public static File[] resolve(String ... qualifiedArtifactIds) {
        int n = qualifiedArtifactIds.length;
        File[] artifacts = new File[n];
        for (int i = 0; i < n; ++i) {
            artifacts[i] = MavenArtifactResolver.resolve(qualifiedArtifactIds[i]);
        }
        return artifacts;
    }
}

