package net.sf.ennahdi.automatic.report.generator.xls.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.ennahdi.automatic.report.generator.generic.engine.Engine;
import net.sf.ennahdi.automatic.report.generator.generic.query.Row;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
/**
 * 
 * @author 	ENNAHDI EL IDRISSI, Mohamed
 * @date	02 September 2016
 *
 */
public abstract class XLSEngine extends Engine {
	private static final Logger logger = LogManager.getLogger(XLSEngine.class);
	
	String path;
	
	public XLSEngine(Connection connection, List<Row> rows, String fileName) {
		super(connection, rows);
		this.path = System.getProperty("user.home") + "//AutomaticReportGenerator/" + fileName;
	}

	@Override
	public File generate() {
		PreparedStatement ps = null;
        ResultSet rs = null;
        FileOutputStream out = null;
        XSSFWorkbook workbook = null;
        try {
            File file = new File(this.path);
            file.getParentFile().mkdirs();
            file.createNewFile();
            XLSEngine.logger.info("Generating " + file.getName());

            int numberOfColumns = 0;
            ResultSetMetaData rsmd = null;
            ps = this.getConnection().prepareStatement(this.getQuery());
            rs = ps.executeQuery();
            rsmd = rs.getMetaData();
            numberOfColumns = rsmd.getColumnCount();

            workbook = new XSSFWorkbook();

            XSSFFont font = workbook.createFont();
            font.setFontName("TAHOMA");

            CellStyle styleEntete = workbook.createCellStyle();
            styleEntete.setBorderBottom(BorderStyle.MEDIUM);
            styleEntete.setBorderLeft(BorderStyle.MEDIUM);
            styleEntete.setBorderRight(BorderStyle.MEDIUM);
            styleEntete.setBorderTop(BorderStyle.MEDIUM);
            styleEntete.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
            styleEntete.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            styleEntete.setFont(font);

            XSSFSheet spreadsheet = workbook.createSheet("data");
            XSSFRow row = spreadsheet.createRow(0);
            XSSFCell cell = row.createCell(0);
            Map<Integer, String> colNames = new HashMap<Integer, String>();
            for (int j = 1; j <= numberOfColumns; j++) {
                colNames.put(j - 1, rsmd.getColumnLabel(j));
                cell = row.createCell(j - 1);
                cell.setCellValue(rsmd.getColumnLabel(j));
                cell.setCellStyle(styleEntete);
            }
            CellStyle style = workbook.createCellStyle();
            style.setBorderBottom(BorderStyle.MEDIUM);
            style.setBorderLeft(BorderStyle.MEDIUM);
            style.setBorderRight(BorderStyle.MEDIUM);
            style.setBorderTop(BorderStyle.MEDIUM);
            style.setFont(font);

            CreationHelper createHelper = workbook.getCreationHelper();
            CellStyle dateCellStyle = workbook.createCellStyle();
            dateCellStyle.setFont(font);
            dateCellStyle.setDataFormat(createHelper.createDataFormat().getFormat("dd/MM/yyyy"));
            dateCellStyle.setBorderBottom(BorderStyle.MEDIUM);
            dateCellStyle.setBorderLeft(BorderStyle.MEDIUM);
            dateCellStyle.setBorderRight(BorderStyle.MEDIUM);
            dateCellStyle.setBorderTop(BorderStyle.MEDIUM);

            int rowID = 1;
            while (rs.next()) {
                row = spreadsheet.createRow(rowID);
                for (int column = 0; column < numberOfColumns; column++) {
                    String value = (String) rs.getString(column + 1);

                    cell = row.createCell(column);
                    cell.setCellStyle(style);
                    Object valeurFormattee = Engine.formatInput(colNames.get(column),value);
                    if (valeurFormattee instanceof Calendar) {
                        cell.setCellStyle(dateCellStyle);
                        cell.setCellValue((Calendar)valeurFormattee);
                    } else {
                        if (valeurFormattee instanceof Double) {
                            cell.setCellValue((Double)(valeurFormattee));
                        } else {
                            if (valeurFormattee instanceof Integer) {
                                cell.setCellValue((Integer)(valeurFormattee));
                            } else {
                                if (valeurFormattee instanceof String) {
                                    cell.setCellValue((String)(valeurFormattee));
                                }
                            }
                        }
                    }
                }
                rowID++;
            }

            for (int i = 0; i < numberOfColumns; i++) {
                spreadsheet.autoSizeColumn(i);
            }

            out = new FileOutputStream(file);
            workbook.write(out);
            XLSEngine.logger.info(file.getName() + " Generated");
            /*
             *
             */
            return file;
        } catch (Exception e) {
        	logger.error(e);
        } finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                this.getConnection().close();
                if (out != null) {
                    try {
						out.close();
					} catch (IOException e) {
						logger.error(e);
					}
                }
                if (workbook != null) {
                	try {
						workbook.close();
					} catch (IOException e) {
						logger.error(e);
					}
                }
            } catch (SQLException e) {
            	logger.error(e);
            }
        }
        return null;

	}

}
