/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ennahdi.automatic.report.generator.xls.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.ennahdi.automatic.report.generator.generic.engine.Engine;
import net.sf.ennahdi.automatic.report.generator.generic.engine.SQLQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public abstract class XLSEngine
extends Engine {
    private static final Logger logger = LogManager.getLogger(XLSEngine.class);
    private static final int COLUMN_WIDTH = 5120;
    private static final int MAX_SPREADSHEET_ROWS = 0x100000;
    String path;
    SXSSFSheet spreadsheet;
    SXSSFRow row;
    SXSSFCell cell;
    SXSSFWorkbook workbook;

    public XLSEngine(Connection connection, SQLQuery sqlQuery, String query, String fileName) {
        super(connection, sqlQuery, query, null);
        this.path = System.getProperty("java.io.tmpdir") + "/AutomaticReportGenerator/" + fileName;
    }

    public XLSEngine(Connection connection, SQLQuery sqlQuery, String query, List<Object> arguments, String fileName) {
        super(connection, sqlQuery, query, arguments);
        this.path = System.getProperty("java.io.tmpdir") + "/AutomaticReportGenerator/" + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generate() {
        Statement ps = null;
        ResultSet rs = null;
        FileOutputStream out = null;
        Connection c = null;
        try {
            File file = new File(this.path);
            if (!file.getParentFile().mkdirs()) {
                logger.info(file.getParentFile().getName() + " already exists.");
            }
            out = new FileOutputStream(file);
            if (!file.createNewFile()) {
                logger.info(file.getName() + " already exists.");
            }
            logger.info("Generating " + file.getName());
            int numberOfColumns = 0;
            ResultSetMetaData rsmd = null;
            c = this.getConnection();
            if (this.getSqlQuery() == SQLQuery.PREPARED_STATEMENT) {
                ps = c.prepareStatement(this.getQuery());
            } else if (this.getSqlQuery() == SQLQuery.CALLABLE_STATEMENT) {
                ps = c.prepareCall(this.getQuery());
            }
            if (this.getArguments() != null) {
                int i = 1;
                for (Object object : this.getArguments()) {
                    if (object instanceof String) {
                        ps.setString(i, (String)object);
                    } else if (object instanceof Integer) {
                        ps.setInt(i, (Integer)object);
                    } else if (object instanceof Timestamp) {
                        ps.setTimestamp(i, (Timestamp)object);
                    } else {
                        ps.setObject(i, object);
                    }
                    ++i;
                }
            }
            rs = ps.executeQuery();
            rsmd = rs.getMetaData();
            numberOfColumns = rsmd.getColumnCount();
            this.workbook = new SXSSFWorkbook();
            Font font = this.newFont("TAHOMA", true);
            CellStyle headerStyle = this.newHeaderStyle(font);
            Map<Integer, String> colNames = this.storeColumnNames(rsmd, numberOfColumns);
            this.newSpreadSheet(rsmd, numberOfColumns, headerStyle);
            Font fontBody = this.newFont(false);
            CellStyle style = this.newBodyStyle(fontBody);
            CellStyle dateCellStyle = this.newDateStyle(fontBody);
            int rowID = 1;
            while (rs.next()) {
                this.row = this.spreadsheet.createRow(rowID);
                for (int column = 0; column < numberOfColumns; ++column) {
                    String value = rs.getString(column + 1);
                    this.cell = this.row.createCell(column);
                    this.cell.setCellStyle(style);
                    this.spreadsheet.setColumnWidth(column, 5120);
                    this.formatCell(colNames, column, value, dateCellStyle);
                }
                if (!this.isMaxSpreadsheetRowsReached(++rowID)) continue;
                this.newSpreadSheet(rsmd, numberOfColumns, headerStyle);
                rowID = 1;
            }
            this.workbook.write((OutputStream)out);
            out.flush();
            logger.info(file.getName() + " Generated");
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            try {
                if (out != null) {
                    out.close();
                }
                if (this.workbook != null) {
                    this.workbook.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return null;
    }

    private void newSpreadSheet(ResultSetMetaData rsmd, int numberOfColumns, CellStyle styleEntete) throws SQLException {
        this.spreadsheet = this.workbook.createSheet("data_" + UUID.randomUUID().toString().substring(0, 5));
        this.row = this.spreadsheet.createRow(0);
        this.cell = this.row.createCell(0);
        for (int j = 1; j <= numberOfColumns; ++j) {
            this.cell = this.row.createCell(j - 1);
            this.cell.setCellValue(rsmd.getColumnLabel(j));
            this.cell.setCellStyle(styleEntete);
        }
    }

    private void formatCell(Map<Integer, String> colNames, int column, String value, CellStyle dateCellStyle) {
        Object formattedValue = Engine.formatInput((String)colNames.get(column), (String)value);
        if (formattedValue instanceof Calendar) {
            this.cell.setCellStyle(dateCellStyle);
            this.cell.setCellValue((Calendar)formattedValue);
        } else if (formattedValue instanceof Double) {
            this.cell.setCellValue(((Double)formattedValue).doubleValue());
        } else if (formattedValue instanceof Integer) {
            this.cell.setCellValue((double)((Integer)formattedValue).intValue());
        } else if (formattedValue instanceof String) {
            this.cell.setCellValue((String)formattedValue);
        } else {
            this.cell.setCellValue(value);
        }
    }

    private boolean isMaxSpreadsheetRowsReached(int rowID) {
        return rowID == 0x100000;
    }

    private CellStyle newHeaderStyle(Font font) {
        CellStyle headerStyle = this.workbook.createCellStyle();
        headerStyle.setBorderBottom(BorderStyle.MEDIUM);
        headerStyle.setBorderLeft(BorderStyle.MEDIUM);
        headerStyle.setBorderRight(BorderStyle.MEDIUM);
        headerStyle.setBorderTop(BorderStyle.MEDIUM);
        headerStyle.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerStyle.setFont(font);
        return headerStyle;
    }

    private CellStyle newDateStyle(Font fontBody) {
        CreationHelper createHelper = this.workbook.getCreationHelper();
        CellStyle dateCellStyle = this.workbook.createCellStyle();
        dateCellStyle.setFont(fontBody);
        dateCellStyle.setDataFormat(createHelper.createDataFormat().getFormat("dd/MM/yyyy"));
        dateCellStyle.setBorderBottom(BorderStyle.MEDIUM);
        dateCellStyle.setBorderLeft(BorderStyle.MEDIUM);
        dateCellStyle.setBorderRight(BorderStyle.MEDIUM);
        dateCellStyle.setBorderTop(BorderStyle.MEDIUM);
        return dateCellStyle;
    }

    private CellStyle newBodyStyle(Font fontBody) {
        CellStyle style = this.workbook.createCellStyle();
        style.setBorderBottom(BorderStyle.MEDIUM);
        style.setBorderLeft(BorderStyle.MEDIUM);
        style.setBorderRight(BorderStyle.MEDIUM);
        style.setBorderTop(BorderStyle.MEDIUM);
        style.setFont(fontBody);
        return style;
    }

    private Map<Integer, String> storeColumnNames(ResultSetMetaData rsmd, int numberOfColumns) throws SQLException {
        HashMap<Integer, String> colNames = new HashMap<Integer, String>();
        for (int j = 1; j <= numberOfColumns; ++j) {
            colNames.put(j - 1, rsmd.getColumnLabel(j));
        }
        return colNames;
    }

    private Font newFont(boolean bold) {
        return this.newFont(null, bold);
    }

    private Font newFont(String fontName, boolean bold) {
        Font font = this.workbook.createFont();
        if (StringUtils.isNotBlank((CharSequence)fontName)) {
            font.setFontName(fontName);
        }
        font.setBold(bold);
        return font;
    }
}

