/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ennahdi.automatic.report.generator.xls.helper;

import com.aspose.cells.Workbook;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import net.sf.ennahdi.automatic.report.generator.xls.exception.XLSGeneratorException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XLSHelper {
    private static final Logger logger = LogManager.getLogger(XLSHelper.class);
    private static final String XLSX_MIME = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    private static final String XLS_MIME = "application/vnd.ms-excel";

    private XLSHelper() {
    }

    public static void convertToPDF(File excelFile) throws Exception {
        logger.info("Checking file to be converted is of type Excel (MimeType)");
        XLSHelper.checkExcelFile(excelFile);
        Workbook w = new Workbook(excelFile.getAbsolutePath());
        logger.info("Converting " + excelFile.getName() + " to PDF.");
        logger.info(excelFile.getName() + " converted to PDF.");
        w.save(excelFile.getAbsolutePath().replace(".xlsx", ".pdf"), 13);
    }

    private static void checkExcelFile(File file) throws IOException, XLSGeneratorException {
        String output = Files.probeContentType(file.toPath());
        if (!XLSX_MIME.equals(output) && !XLS_MIME.equals(output)) {
            throw new XLSGeneratorException("The file you are trying to convert is not of type Excel");
        }
    }
}

