/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.examples;

import java.lang.reflect.Method;
import net.objectlab.kit.console.ConsoleMenu;
import net.objectlab.kit.console.Repeater;
import net.sf.flatpack.examples.createsamplecsv.CSVTestFileCreator;
import net.sf.flatpack.examples.csvheaderandtrailer.CSVHeaderAndTrailer;
import net.sf.flatpack.examples.csvperformancetest.CSVPerformanceTest;
import net.sf.flatpack.examples.delimiteddynamiccolumns.DelimitedWithPZMap;
import net.sf.flatpack.examples.delimiteddynamiccolumnswitherrors.DelimitedWithPZMapErrors;
import net.sf.flatpack.examples.exporttoexcel.DelimitedFileExportToExcel;
import net.sf.flatpack.examples.fixedlengthdynamiccolumns.FixedLengthWithPZMap;
import net.sf.flatpack.examples.fixedlengthheaderandtrailer.FixedLengthHeaderAndTrailer;
import net.sf.flatpack.examples.largedataset.delimiteddynamiccolumns.LargeDelimitedWithPZMap;
import net.sf.flatpack.examples.largedataset.fixedlengthdynamiccolumns.LargeFixedLengthWithPZMap;
import net.sf.flatpack.examples.largedataset.largecsvperformancetest.CSVLarge;
import net.sf.flatpack.examples.lowlevelparse.LowLevelParse;
import net.sf.flatpack.examples.multilinedelimitedrecord.DelimitedMultiLine;
import net.sf.flatpack.examples.numericsanddates.NumericsAndDates;
import net.sf.flatpack.util.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Examples
implements Repeater {
    private static final String ISSUE = "Issue";
    private static final String DATA2 = "Data   ";
    private static final String MAPPING2 = "Mapping ";
    private static final Logger LOG = LoggerFactory.getLogger(Examples.class);

    public void tearDown() {
    }

    public static void main(String[] args) {
        Examples examples = new Examples();
        examples.run();
    }

    public void repeat(Method target) {
    }

    public void doCall() {
        System.err.println("");
        System.err.println("           ___  _     _           _   _          _");
        System.err.println("          / _ \\| |__ (_) ___  ___| |_| |    __ _| |__");
        System.err.println("         | | | | '_ \\| |/ _ \\/ __| __| |   / _` | '_ \\");
        System.err.println("         | |_| | |_) | |  __/ (__| |_| |__| (_| | |_) |");
        System.err.println("          \\___/|_.__// |\\___|\\___|\\__|_____\\__,_|_.__/");
        System.err.println("                   |__/");
        System.err.println("");
        System.err.println("             w w w . O b j e c t L a b . c o . u k");
    }

    private void run() {
        ConsoleMenu menu = new ConsoleMenu((Repeater)this);
        menu.addMenuItem("CSVTestFileCreator", "doCSVTestFileCreator", false);
        menu.addMenuItem("CSVHeaderAndTrailer", "doCSVHeaderAndTrailer", false);
        menu.addMenuItem("CSVPerformanceTest", "doCSVPerformanceTest", false);
        menu.addMenuItem("DelimitedWithPZMap", "doDelimitedWithPZMap", false);
        menu.addMenuItem("DelimitedWithPZMapErrors", "doDelimitedWithPZMapErrors", false);
        menu.addMenuItem("DelimitedFileExportToExcel", "doDelimitedFileExportToExcel", false);
        menu.addMenuItem("FixedLengthWithPZMap", "doFixedLengthWithPZMap", false);
        menu.addMenuItem("FixedLengthHeaderAndTrailer", "doFixedLengthHeaderAndTrailer", false);
        menu.addMenuItem("LargeDelimitedWithPZMap", "doLargeDelimitedWithPZMap", false);
        menu.addMenuItem("LargeFixedLengthWithPZMap", "doLargeFixedLengthWithPZMap", false);
        menu.addMenuItem("CSVLarge", "doCSVLarge", false);
        menu.addMenuItem("LowLevelParse", "doLowLevelParse", false);
        menu.addMenuItem("DelimitedMultiLine", "doDelimitedMultiLine", false);
        menu.addMenuItem("NumericsAndDates", "doNumericsAndDates", false);
        menu.addMenuItem("Ask for GC", "doGC", false);
        menu.addMenuItem("Test StringBuffer", "doStringBuffer", false);
        menu.addMenuItem("Test Delim Parser Perform", "doTestParsers", false);
        menu.addMenuItem("Who you gonna call?", "doCall", false);
        menu.displayMenu();
    }

    public void doCSVTestFileCreator() {
        int cols = ConsoleMenu.getInt((String)"Number of cols", (int)10);
        int rows = ConsoleMenu.getInt((String)"Number of rows", (int)100);
        CSVTestFileCreator.createFile(cols, rows);
    }

    public void doCSVHeaderAndTrailer() {
        try {
            String mapping = ConsoleMenu.getString((String)MAPPING2, (String)CSVHeaderAndTrailer.getDefaultMapping());
            String data = ConsoleMenu.getString((String)DATA2, (String)CSVHeaderAndTrailer.getDefaultDataFile());
            CSVHeaderAndTrailer.call(mapping, data);
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doCSVPerformanceTest() {
        try {
            String mapping = ConsoleMenu.getString((String)"CSV File ", (String)"SampleCSV.csv");
            boolean data = ConsoleMenu.getBoolean((String)"Traverse the entire parsed file", (boolean)true);
            boolean verbose = ConsoleMenu.getBoolean((String)"Verbose", (boolean)false);
            CSVPerformanceTest.call(mapping, verbose, data);
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doDelimitedWithPZMap() {
        try {
            String mapping = ConsoleMenu.getString((String)MAPPING2, (String)DelimitedWithPZMap.getDefaultMapping());
            String data = ConsoleMenu.getString((String)DATA2, (String)DelimitedWithPZMap.getDefaultDataFile());
            DelimitedWithPZMap.call(mapping, data);
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doDelimitedWithPZMapErrors() {
        try {
            String mapping = ConsoleMenu.getString((String)MAPPING2, (String)DelimitedWithPZMapErrors.getDefaultMapping());
            String data = ConsoleMenu.getString((String)DATA2, (String)DelimitedWithPZMapErrors.getDefaultDataFile());
            DelimitedWithPZMapErrors.call(mapping, data);
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doDelimitedFileExportToExcel() {
        try {
            String mapping = ConsoleMenu.getString((String)MAPPING2, (String)DelimitedFileExportToExcel.getDefaultMapping());
            String data = ConsoleMenu.getString((String)DATA2, (String)DelimitedFileExportToExcel.getDefaultDataFile());
            DelimitedFileExportToExcel.call(mapping, data);
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doFixedLengthWithPZMap() {
        try {
            String mapping = ConsoleMenu.getString((String)MAPPING2, (String)FixedLengthWithPZMap.getDefaultMapping());
            String data = ConsoleMenu.getString((String)DATA2, (String)FixedLengthWithPZMap.getDefaultDataFile());
            FixedLengthWithPZMap.call(mapping, data);
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doFixedLengthHeaderAndTrailer() {
        try {
            String mapping = ConsoleMenu.getString((String)MAPPING2, (String)FixedLengthHeaderAndTrailer.getDefaultMapping());
            String data = ConsoleMenu.getString((String)DATA2, (String)FixedLengthHeaderAndTrailer.getDefaultDataFile());
            FixedLengthHeaderAndTrailer.call(mapping, data);
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doLargeDelimitedWithPZMap() {
        try {
            String mapping = ConsoleMenu.getString((String)MAPPING2, (String)LargeDelimitedWithPZMap.getDefaultMapping());
            String data = ConsoleMenu.getString((String)DATA2, (String)LargeDelimitedWithPZMap.getDefaultDataFile());
            LargeDelimitedWithPZMap.call(mapping, data);
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doLargeFixedLengthWithPZMap() {
        try {
            String mapping = ConsoleMenu.getString((String)MAPPING2, (String)LargeFixedLengthWithPZMap.getDefaultMapping());
            String data = ConsoleMenu.getString((String)DATA2, (String)LargeFixedLengthWithPZMap.getDefaultDataFile());
            LargeFixedLengthWithPZMap.call(mapping, data);
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doCSVLarge() {
        try {
            int cols = ConsoleMenu.getInt((String)"Number of cols", (int)10);
            int rows = ConsoleMenu.getInt((String)"Number of rows", (int)2000000);
            String filename = "LargeSampleCSV.csv";
            CSVTestFileCreator.createFile(cols, rows, "LargeSampleCSV.csv");
            System.err.println("Large file created");
            CSVLarge.call("LargeSampleCSV.csv");
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doLowLevelParse() {
        try {
            String data = ConsoleMenu.getString((String)DATA2, (String)LowLevelParse.getDefaultDataFile());
            LowLevelParse.call(data);
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doDelimitedMultiLine() {
        try {
            String data = ConsoleMenu.getString((String)DATA2, (String)DelimitedMultiLine.getDefaultDataFile());
            DelimitedMultiLine.call(data);
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doNumericsAndDates() {
        try {
            String mapping = ConsoleMenu.getString((String)MAPPING2, (String)NumericsAndDates.getDefaultMapping());
            String data = ConsoleMenu.getString((String)DATA2, (String)NumericsAndDates.getDefaultDataFile());
            NumericsAndDates.call(mapping, data);
        }
        catch (Exception e) {
            LOG.error(ISSUE, (Throwable)e);
        }
    }

    public void doStringBuffer() {
        int repeat = ConsoleMenu.getInt((String)"How many times?", (int)100000);
        int characters = ConsoleMenu.getInt((String)"How many char?", (int)20);
        long start = System.currentTimeMillis();
        for (int i = 0; i < repeat; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int u = 0; u < 1000; ++u) {
                sb.append("h");
            }
        }
        long stop = System.currentTimeMillis();
        System.err.println("Creating new SB " + (stop - start) + " ms.");
        start = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < repeat; ++i) {
            for (int u = 0; u < characters; ++u) {
                sb.append("h");
            }
            sb.delete(0, sb.length());
        }
        stop = System.currentTimeMillis();
        System.err.println("Deleting existing SB " + (stop - start) + " ms.");
    }

    public void doTestParsers() {
        int repeat = ConsoleMenu.getInt((String)"How many Rows?", (int)1000);
        int numberOfCols = ConsoleMenu.getInt((String)"How many columns?", (int)100);
        boolean qualif = ConsoleMenu.getBoolean((String)"With qualifier?", (boolean)true);
        StringBuilder aRow = new StringBuilder();
        for (int i = 0; i < numberOfCols; ++i) {
            if (qualif) {
                aRow.append("\"");
            }
            aRow.append("Column ").append(i);
            if (!qualif) continue;
            aRow.append("\"");
        }
        String line = aRow.toString();
        long start = System.currentTimeMillis();
        for (int i = 0; i < repeat; ++i) {
            ParserUtils.splitLine((String)line, (char)',', (char)'\"', (int)10, (boolean)false, (boolean)false);
        }
        long stop = System.currentTimeMillis();
        System.err.println("ParserUtil " + (stop - start) + " ms.");
    }
}

