/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.examples.createsamplecsv;

import java.io.FileWriter;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVTestFileCreator {
    private static final Logger LOG = LoggerFactory.getLogger(CSVTestFileCreator.class);

    public static void main(String[] args) {
        int cols = 0;
        int rows = 0;
        if (args.length != 2) {
            CSVTestFileCreator.printUsage();
            return;
        }
        try {
            cols = Integer.parseInt(args[0]);
            rows = Integer.parseInt(args[1]);
        }
        catch (Exception ex) {
            CSVTestFileCreator.printUsage();
            return;
        }
        CSVTestFileCreator.createFile(cols, rows);
    }

    public static void createFile(int cols, int rows) {
        CSVTestFileCreator.createFile(cols, rows, "SampleCSV.csv");
    }

    public static void createFile(int cols, int rows, String filename) {
        try (FileWriter fw = new FileWriter(filename);
             PrintWriter out = new PrintWriter(fw);){
            int i;
            for (i = 1; i <= cols; ++i) {
                if (i > 1) {
                    out.write(",");
                }
                out.write("\"column " + i + "\"");
            }
            out.write("\r\n");
            out.flush();
            for (i = 1; i <= rows; ++i) {
                for (int j = 1; j <= cols; ++j) {
                    if (j > 1) {
                        out.write(",");
                    }
                    out.write("\"data " + j + "\"");
                }
                out.write("\r\n");
                out.flush();
                if (i % 100000 != 0) continue;
                System.out.print(".");
            }
        }
        catch (Exception ex) {
            LOG.error("Issue", (Throwable)ex);
        }
    }

    private static void printUsage() {
        System.out.println("INVALID USAGE...");
        System.out.println("PARAMETER 1 = # OF COLUMNS");
        System.out.println("PARAMETER 2 = # OF ROWS");
        System.out.println("Example - java CSVTestFileCreator 10 100");
    }
}

