/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.examples.csvheaderandtrailer;

import java.io.File;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultParserFactory;
import net.sf.flatpack.Parser;

public class CSVHeaderAndTrailer {
    public static void main(String[] args) throws Exception {
        CSVHeaderAndTrailer.call(CSVHeaderAndTrailer.getDefaultMapping(), CSVHeaderAndTrailer.getDefaultDataFile());
    }

    public static String getDefaultMapping() {
        return "PEOPLE-DelimitedWithHeaderTrailer.pzmap.xml";
    }

    public static String getDefaultDataFile() {
        return "PEOPLE-CommaDelimitedWithQualifier.txt";
    }

    public static void call(String mapping, String data) throws Exception {
        File mapFile = new File(mapping);
        File dataFile = new File(data);
        Parser pzparser = DefaultParserFactory.getInstance().newDelimitedParser(mapFile, dataFile, ',', '\"', true);
        DataSet ds = pzparser.parse();
        while (ds.next()) {
            if (ds.isRecordID("header")) {
                System.out.println(">>>>>>Found Header Record");
                System.out.println("COLUMN NAME: RECORDINDICATOR VALUE: " + ds.getString("RECORDINDICATOR"));
                System.out.println("COLUMN NAME: HEADERDATA VALUE: " + ds.getString("HEADERDATA"));
                System.out.println("===========================================================================");
                continue;
            }
            if (ds.isRecordID("trailer")) {
                System.out.println(">>>>>>Found Trailer Record");
                System.out.println("COLUMN NAME: RECORDINDICATOR VALUE: " + ds.getString("RECORDINDICATOR"));
                System.out.println("COLUMN NAME: TRAILERDATA VALUE: " + ds.getString("TRAILERDATA"));
                System.out.println("===========================================================================");
                continue;
            }
            System.out.println("COLUMN NAME: FIRSTNAME VALUE: " + ds.getString("FIRSTNAME"));
            System.out.println("COLUMN NAME: LASTNAME VALUE: " + ds.getString("LASTNAME"));
            System.out.println("COLUMN NAME: ADDRESS VALUE: " + ds.getString("ADDRESS"));
            System.out.println("COLUMN NAME: CITY VALUE: " + ds.getString("CITY"));
            System.out.println("COLUMN NAME: STATE VALUE: " + ds.getString("STATE"));
            System.out.println("COLUMN NAME: ZIP VALUE: " + ds.getString("ZIP"));
            System.out.println("===========================================================================");
        }
        if (ds.getErrors() != null && !ds.getErrors().isEmpty()) {
            System.out.println("FOUND ERRORS IN FILE");
        }
    }
}

