/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.examples.csvperformancetest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import net.sf.flatpack.DataError;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultParserFactory;
import net.sf.flatpack.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVPerformanceTest {
    private static final Logger LOG = LoggerFactory.getLogger(CSVPerformanceTest.class);

    public static void main(String[] args) {
        Map<String, String> settings = null;
        try {
            settings = CSVPerformanceTest.readSettings();
            String filename = settings.get("csvFile");
            String verbose = settings.get("verbose");
            CSVPerformanceTest.call(filename, Boolean.parseBoolean(verbose), true);
        }
        catch (Exception ex) {
            LOG.error("Issue", (Throwable)ex);
        }
    }

    public static void call(String filename, boolean verbose, boolean traverse) throws Exception, InterruptedException {
        String[] colNames = null;
        System.out.println("Parsing....");
        Parser pzparser = DefaultParserFactory.getInstance().newDelimitedParser(new File(filename), ',', '\"');
        long timeStarted = System.currentTimeMillis();
        DataSet ds = pzparser.parse();
        long timeFinished = System.currentTimeMillis();
        String timeMessage = "";
        timeMessage = timeFinished - timeStarted < 1000L ? timeFinished - timeStarted + " Milleseconds..." : (float)((double)(timeFinished - timeStarted) / 1000.0) + " Seconds...";
        System.out.println("");
        System.out.println("********FILE PARSED IN: " + timeMessage + " ******");
        if (traverse) {
            if (verbose) {
                Thread.sleep(2000L);
            }
            timeStarted = System.currentTimeMillis();
            colNames = ds.getColumns();
            int rowCount = 0;
            int colCount = colNames.length;
            while (ds.next()) {
                ++rowCount;
                for (String colName : colNames) {
                    String string = ds.getString(colName);
                    if (!verbose) continue;
                    System.out.println("COLUMN NAME: " + colName + " VALUE: " + string);
                }
                if (!verbose) continue;
                System.out.println("===========================================================================");
            }
            timeFinished = System.currentTimeMillis();
            timeMessage = timeFinished - timeStarted < 1000L ? timeFinished - timeStarted + " Milleseconds..." : (float)((double)(timeFinished - timeStarted) / 1000.0) + " Seconds...";
            System.out.println("");
            System.out.println("********Traversed Data In: " + timeMessage + " (rows: " + rowCount + " Col:" + colCount + ") ******");
        }
        if (ds.getErrors() != null && !ds.getErrors().isEmpty()) {
            System.out.println("FOUND ERRORS IN FILE....");
            for (int i = 0; i < ds.getErrors().size(); ++i) {
                DataError de = (DataError)ds.getErrors().get(i);
                System.out.println("Error: " + de.getErrorDesc() + " Line: " + de.getLineNo());
            }
        }
    }

    private static Map<String, String> readSettings() throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        try (FileReader fr = new FileReader("settings.properties");
             BufferedReader br = new BufferedReader(fr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0 || line.startsWith("#") || line.indexOf("=") == -1) continue;
                result.put(line.substring(0, line.indexOf("=")), line.substring(line.indexOf("=") + 1));
            }
        }
        return result;
    }
}

