/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.examples.exporttoexcel;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import net.sf.flatpack.DataError;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultParserFactory;
import net.sf.flatpack.Parser;
import net.sf.flatpack.excel.ExcelTransformer;
import net.sf.flatpack.ordering.OrderBy;
import net.sf.flatpack.ordering.OrderColumn;

public class DelimitedFileExportToExcel {
    public static void main(String[] args) throws Exception {
        String mapping = DelimitedFileExportToExcel.getDefaultMapping();
        String data = DelimitedFileExportToExcel.getDefaultDataFile();
        DelimitedFileExportToExcel.call(mapping, data);
    }

    public static String getDefaultDataFile() {
        return "PEOPLE-CommaDelimitedWithQualifier.txt";
    }

    public static String getDefaultMapping() {
        return "PEOPLE-Delimited.pzmap.xml";
    }

    public static void call(String mapping, String data) throws Exception {
        Parser pzparser = DefaultParserFactory.getInstance().newDelimitedParser((Reader)new FileReader(mapping), (Reader)new FileReader(data), ',', '\"', true);
        DataSet ds = pzparser.parse();
        OrderBy orderby = new OrderBy();
        orderby.addOrderColumn(new OrderColumn("CITY", false));
        orderby.addOrderColumn(new OrderColumn("LASTNAME", true));
        ds.orderRows(orderby);
        if (ds.getErrors() != null && !ds.getErrors().isEmpty()) {
            for (int i = 0; i < ds.getErrors().size(); ++i) {
                DataError de = (DataError)ds.getErrors().get(i);
                System.out.println("Error Msg: " + de.getErrorDesc() + " Line: " + de.getLineNo());
            }
        }
        File xlFile = new File("MyExcelExport.xls");
        ExcelTransformer xlTransformer = new ExcelTransformer(ds, xlFile);
        xlTransformer.writeExcelFile();
        System.out.println("Excel Workbook Written To: " + xlFile.getAbsolutePath());
    }
}

