/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.examples.fixedlengthheaderandtrailer;

import java.io.FileReader;
import java.io.Reader;
import java.util.Iterator;
import net.sf.flatpack.DataError;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultParserFactory;
import net.sf.flatpack.Parser;

public class FixedLengthHeaderAndTrailer {
    public static void main(String[] args) throws Exception {
        String mapping = FixedLengthHeaderAndTrailer.getDefaultMapping();
        String data = FixedLengthHeaderAndTrailer.getDefaultDataFile();
        FixedLengthHeaderAndTrailer.call(mapping, data);
    }

    public static String getDefaultDataFile() {
        return "PEOPLE-FixedLengthWithHeaderTrailer.txt";
    }

    public static String getDefaultMapping() {
        return "PEOPLE-FixedLengthWithHeaderTrailer.pzmap.xml";
    }

    public static void call(String mapping, String data) throws Exception {
        Iterator errors = null;
        DataError dataError2 = null;
        Parser pzparser = DefaultParserFactory.getInstance().newFixedLengthParser((Reader)new FileReader(mapping), (Reader)new FileReader(data));
        DataSet ds = pzparser.parse();
        while (ds.next()) {
            if (ds.isRecordID("header")) {
                System.out.println(">>>>found header");
                System.out.println("COLUMN NAME: INDICATOR VALUE: " + ds.getString("INDICATOR"));
                System.out.println("COLUMN NAME: HEADERDATA VALUE: " + ds.getString("HEADERDATA"));
                System.out.println("===========================================================================");
                continue;
            }
            if (ds.isRecordID("trailer")) {
                System.out.println(">>>>found trailer");
                System.out.println("COLUMN NAME: INDICATOR VALUE: " + ds.getString("INDICATOR"));
                System.out.println("COLUMN NAME: TRAILERDATA VALUE: " + ds.getString("TRAILERDATA"));
                System.out.println("===========================================================================");
                continue;
            }
            System.out.println("COLUMN NAME: FIRSTNAME VALUE: " + ds.getString("FIRSTNAME"));
            System.out.println("COLUMN NAME: LASTNAME VALUE: " + ds.getString("LASTNAME"));
            System.out.println("COLUMN NAME: ADDRESS VALUE: " + ds.getString("ADDRESS"));
            System.out.println("COLUMN NAME: CITY VALUE: " + ds.getString("CITY"));
            System.out.println("COLUMN NAME: STATE VALUE: " + ds.getString("STATE"));
            System.out.println("COLUMN NAME: ZIP VALUE: " + ds.getString("ZIP"));
            System.out.println("===========================================================================");
        }
        if (ds.getErrors() != null && !ds.getErrors().isEmpty()) {
            for (DataError dataError2 : ds.getErrors()) {
                System.out.println("ERROR: " + dataError2.getErrorDesc() + " LINE NUMBER: " + dataError2.getLineNo());
            }
        }
    }
}

