/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.examples.largedataset.delimiteddynamiccolumns;

import java.io.FileReader;
import java.io.Reader;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.brparse.BuffReaderDelimParser;
import net.sf.flatpack.brparse.BuffReaderParseFactory;

public class LargeDelimitedWithPZMap {
    public static void main(String[] args) throws Exception {
        String mapping = LargeDelimitedWithPZMap.getDefaultMapping();
        String data = LargeDelimitedWithPZMap.getDefaultDataFile();
        LargeDelimitedWithPZMap.call(mapping, data);
    }

    public static String getDefaultDataFile() {
        return "PEOPLE-CommaDelimitedWithQualifier.txt";
    }

    public static String getDefaultMapping() {
        return "PEOPLE-Delimited.pzmap.xml";
    }

    public static void call(String mapping, String data) throws Exception {
        String[] colNames = null;
        try (FileReader pzmap = new FileReader(mapping);
             FileReader fileToParse = new FileReader(data);
             BuffReaderDelimParser pzparse = (BuffReaderDelimParser)BuffReaderParseFactory.getInstance().newDelimitedParser((Reader)pzmap, (Reader)fileToParse, ',', '\"', true);){
            DataSet ds = pzparse.parse();
            colNames = ds.getColumns();
            while (ds.next()) {
                for (String colName : colNames) {
                    System.out.println("COLUMN NAME: " + colName + " VALUE: " + ds.getString(colName));
                }
                System.out.println("===========================================================================");
            }
            if (ds.getErrors() != null && !ds.getErrors().isEmpty()) {
                System.out.println("FOUND ERRORS IN FILE");
            }
        }
    }
}

