/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.examples.largedataset.fixedlengthdynamiccolumns;

import java.io.FileReader;
import java.io.Reader;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.brparse.BuffReaderFixedParser;
import net.sf.flatpack.brparse.BuffReaderParseFactory;

public class LargeFixedLengthWithPZMap {
    public static void main(String[] args) throws Exception {
        String mapping = LargeFixedLengthWithPZMap.getDefaultMapping();
        String data = LargeFixedLengthWithPZMap.getDefaultDataFile();
        LargeFixedLengthWithPZMap.call(mapping, data);
    }

    public static String getDefaultDataFile() {
        return "PEOPLE-FixedLength.txt";
    }

    public static String getDefaultMapping() {
        return "PEOPLE-FixedLength.pzmap.xml";
    }

    public static void call(String mapping, String data) throws Exception {
        String[] colNames = null;
        try (BuffReaderFixedParser pzparse = (BuffReaderFixedParser)BuffReaderParseFactory.getInstance().newFixedLengthParser((Reader)new FileReader(mapping), (Reader)new FileReader(data));){
            DataSet ds = pzparse.parse();
            colNames = ds.getColumns();
            while (ds.next()) {
                for (String colName : colNames) {
                    System.out.println("COLUMN NAME: " + colName + " VALUE: " + ds.getString(colName));
                }
                System.out.println("===========================================================================");
            }
        }
    }
}

