/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.examples.largedataset.largecsvperformancetest;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.sf.flatpack.DataError;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.brparse.BuffReaderDelimParser;
import net.sf.flatpack.brparse.BuffReaderParseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVLarge {
    private static final Logger LOG = LoggerFactory.getLogger(CSVLarge.class);

    public static void main(String[] args) {
        try {
            Map settings = CSVLarge.readSettings();
            String data = (String)settings.get("csvFile");
            CSVLarge.call(data);
        }
        catch (Exception e) {
            LOG.error("issue", (Throwable)e);
        }
    }

    public static String getDefaultDataFile() {
        return "LargeSampleCSV.csv";
    }

    public static void call(String data) throws Exception {
        try (BuffReaderDelimParser pzparse = (BuffReaderDelimParser)BuffReaderParseFactory.getInstance().newDelimitedParser((Reader)new FileReader(data), ',', '\"');){
            DataSet ds = pzparse.parse();
            long timeStarted = System.currentTimeMillis();
            int totalCount = 0;
            int tmpCount = 0;
            while (ds.next()) {
                ++totalCount;
                if (++tmpCount < 2500) continue;
                System.out.println("Read " + totalCount + " Records...");
                tmpCount = 0;
            }
            long timeFinished = System.currentTimeMillis();
            String timeMessage = "";
            timeMessage = timeFinished - timeStarted < 1000L ? timeFinished - timeStarted + " Milleseconds..." : (timeFinished - timeStarted) / 1000L + " Seconds...";
            System.out.println("");
            System.out.println("********FILE PARSED IN: " + timeMessage + " ******");
            if (ds.getErrors() != null && !ds.getErrors().isEmpty()) {
                System.out.println("FOUND ERRORS IN FILE....");
                for (int i = 0; i < ds.getErrors().size(); ++i) {
                    DataError de = (DataError)ds.getErrors().get(i);
                    System.out.println("Error: " + de.getErrorDesc() + " Line: " + de.getLineNo());
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Issue", (Throwable)ex);
        }
    }

    private static Map readSettings() throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        try (FileReader fr = new FileReader("settings.properties");
             BufferedReader br = new BufferedReader(fr);){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0 || line.startsWith("#") || line.indexOf("=") == -1) continue;
                result.put(line.substring(0, line.indexOf("=")), line.substring(line.indexOf("=") + 1));
            }
        }
        return result;
    }
}

