/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.examples.lowlevelparse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import net.sf.flatpack.util.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowLevelParse {
    private static final Logger LOG = LoggerFactory.getLogger(LowLevelParse.class);

    public static void main(String[] args) {
        String data = LowLevelParse.getDefaultDataFile();
        try {
            LowLevelParse.call(data);
        }
        catch (Exception e) {
            LOG.error("issue", (Throwable)e);
        }
    }

    public static String getDefaultDataFile() {
        return "PEOPLE-CommaDelimitedWithQualifier.txt";
    }

    public static void call(String data) throws Exception {
        File textFile = new File(data);
        String line = null;
        List elements = null;
        try (FileReader fr = new FileReader(textFile);
             BufferedReader br = new BufferedReader(fr);){
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                elements = ParserUtils.splitLine((String)line, (char)',', (char)'\"', (int)10, (boolean)false, (boolean)false);
                for (int i = 0; i < elements.size(); ++i) {
                    System.out.println("Column " + i + ": " + (String)elements.get(i));
                }
                System.out.println("===========================================================================");
            }
        }
        catch (Exception ex) {
            LOG.error("issue", (Throwable)ex);
        }
    }
}

