/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.examples.multilinedelimitedrecord;

import java.io.FileReader;
import java.io.Reader;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultParserFactory;
import net.sf.flatpack.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelimitedMultiLine {
    private static final Logger LOG = LoggerFactory.getLogger(DelimitedMultiLine.class);

    public static void main(String[] args) throws Exception {
        String data = DelimitedMultiLine.getDefaultDataFile();
        try {
            DelimitedMultiLine.call(data);
        }
        catch (Exception e) {
            LOG.error("Issue", (Throwable)e);
        }
    }

    public static String getDefaultDataFile() {
        return "PEOPLE-CommaDelimitedWithQualifierMultiLine.txt";
    }

    public static void call(String data) throws Exception {
        Parser pzparser = DefaultParserFactory.getInstance().newDelimitedParser((Reader)new FileReader(data), ',', '\"');
        DataSet ds = pzparser.parse();
        String[] colNames = ds.getColumns();
        while (ds.next()) {
            for (String colName : colNames) {
                System.out.println("COLUMN NAME: " + colName + " VALUE: " + ds.getString(colName));
            }
            System.out.println("===========================================================================");
        }
        if (ds.getErrors() != null && !ds.getErrors().isEmpty()) {
            System.out.println("FOUND ERRORS IN FILE");
        }
    }
}

