/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.examples.numericsanddates;

import java.io.FileReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultParserFactory;
import net.sf.flatpack.Parser;

public class NumericsAndDates {
    public static void main(String[] args) throws Exception {
        String mapping = NumericsAndDates.getDefaultMapping();
        String data = NumericsAndDates.getDefaultDataFile();
        NumericsAndDates.call(mapping, data);
    }

    public static String getDefaultDataFile() {
        return "INVENTORY-CommaDelimitedWithQualifier.txt";
    }

    public static String getDefaultMapping() {
        return "INVENTORY-Delimited.pzmap.xml";
    }

    public static void call(String mapping, String data) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        Parser pzparser = DefaultParserFactory.getInstance().newDelimitedParser((Reader)new FileReader(mapping), (Reader)new FileReader(data), ',', '\"', true);
        DataSet ds = pzparser.parse();
        while (ds.next()) {
            System.out.println("Item Desc: " + ds.getString("ITEM_DESC") + " (String)");
            System.out.println("In Stock: " + ds.getInt("IN_STOCK") + " (int)");
            System.out.println("Price: " + ds.getDouble("PRICE") + " (double)");
            System.out.println("Received Dt: " + sdf.format(ds.getDate("LAST_RECV_DT")) + " (Date)");
            System.out.println("===========================================================================");
        }
    }
}

