/*
 * Decompiled with CFR 0.152.
 */
package sim.android.hardware.service;

import java.io.Serializable;

public class SimSensorEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_ACCELEROMETER = 1;
    public static final int TYPE_MAGNETIC_FIELD = 2;
    @Deprecated
    public static final int TYPE_ORIENTATION = 3;
    public static final int TYPE_GYROSCOPE = 4;
    public static final int TYPE_LIGHT = 5;
    public static final int TYPE_PRESSURE = 6;
    public static final int TYPE_TEMPERATURE = 7;
    public static final int TYPE_PROXIMITY = 8;
    public static final int TYPE_GRAVITY = 9;
    public static final int TYPE_LINEAR_ACCELERATION = 10;
    public static final int TYPE_ROTATION_VECTOR = 11;
    public static final int PORT = 34567;
    private float[] values;
    private int type;
    private int accuracy;
    private long step;

    public SimSensorEvent(int type, float[] values, long step, int accuracy) {
        this.type = type;
        this.values = values;
        this.step = step;
        this.accuracy = accuracy;
    }

    public float[] getValues() {
        return this.values;
    }

    public int getType() {
        return this.type;
    }

    public long getStep() {
        return this.step;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public String toString() {
        super.toString();
        String result = "step=" + this.step + ", Type=";
        switch (this.type) {
            case 1: {
                result = result + "TYPE_ACCELEROMETER";
                break;
            }
            case 2: {
                result = result + "TYPE_MAGNETIC_FIELD";
                break;
            }
            case 3: {
                result = result + "TYPE_ORIENTATION";
            }
        }
        result = result + ", accuracy=" + this.accuracy + ", x(" + this.values[0] + ")" + "y(" + this.values[1] + ")" + "z(" + this.values[2] + ")";
        return result;
    }
}

