/*
 * Decompiled with CFR 0.152.
 */
package sim.android.hardware.service.utils;

public class Vector {
    public double x;
    public double y;
    public double z;

    public Vector() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector(Vector v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(double[] vec) {
        this.x = vec[0];
        this.y = vec[1];
        this.z = vec[2];
    }

    public void scale(double factor) {
        this.x = factor * this.x;
        this.y = factor * this.y;
        this.z = factor * this.z;
    }

    public void rotateAroundZ(double angle) {
        Vector v = new Vector(this);
        double yawRad = Math.toRadians(angle);
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        this.x = cos * v.x + sin * v.y;
        this.y = -sin * v.x + cos * v.y;
        this.z = v.z;
    }

    public void rotateAroundX(double angle) {
        Vector v = new Vector(this);
        double pitchRad = Math.toRadians(angle);
        double cos = Math.cos(pitchRad);
        double sin = Math.sin(pitchRad);
        this.x = v.x;
        this.y = cos * v.y + sin * v.z;
        this.z = -sin * v.y + cos * v.z;
    }

    public void rotateAroundY(double angle) {
        Vector v = new Vector(this);
        double rollRad = Math.toRadians(angle);
        double cos = Math.cos(rollRad);
        double sin = Math.sin(rollRad);
        this.x = cos * v.x + sin * v.z;
        this.y = v.y;
        this.z = -sin * v.x + cos * v.z;
    }
}

