package sim.android.hardware.service;

import java.io.Serializable;

public class SimLocationEvent implements Serializable {
	public static final int PORT = 10455;
	
	/**
     * Name of the network location provider.  This provider determines location based on
     * availability of cell tower and WiFi access points. Results are retrieved
     * by means of a network lookup.
     *
     * Requires either of the permissions android.permission.ACCESS_COARSE_LOCATION
     * or android.permission.ACCESS_FINE_LOCATION.
     */
    public static final String NETWORK_PROVIDER = "network";

    /**
     * Name of the GPS location provider. This provider determines location using
     * satellites. Depending on conditions, this provider may take a while to return
     * a location fix.
     *
     * Requires the permission android.permission.ACCESS_FINE_LOCATION.
     *
     * <p> The extras Bundle for the GPS location provider can contain the
     * following key/value pairs:
     *
     * <ul>
     * <li> satellites - the number of satellites used to derive the fix
     * </ul>
     */
    public static final String GPS_PROVIDER = "gps";

    /**
     * A special location provider for receiving locations without actually initiating
     * a location fix. This provider can be used to passively receive location updates
     * when other applications or services request them without actually requesting
     * the locations yourself.  This provider will return locations generated by other
     * providers.  You can query the {@link Location#getProvider()} method to determine
     * the origin of the location update.
     *
     * Requires the permission android.permission.ACCESS_FINE_LOCATION, although if the GPS
     * is not enabled this provider might only return coarse fixes.
     */
    public static final String PASSIVE_PROVIDER = "passive";
    
	private String mProvider;
    private long mTime = 0;
    private double mLatitude = 0.0;
    private double mLongitude = 0.0;
    private boolean mHasAltitude = false;
    private double mAltitude = 0.0f;
    private boolean mHasSpeed = false;
    private float mSpeed = 0.0f;
    private boolean mHasBearing = false;
    private float mBearing = 0.0f;
    private boolean mHasAccuracy = false;
    private float mAccuracy = 0.0f;
    
    public SimLocationEvent(String provider, double latitude, double longitude) {
    	this.mProvider = provider;
    	this.mLatitude = latitude;
    	this.mLongitude = longitude;
    }
    
	public String getProvider() {
		return mProvider;
	}
	public void setProvider(String mProvider) {
		this.mProvider = mProvider;
	}
	public long getTime() {
		return mTime;
	}
	public void setTime(long mTime) {
		this.mTime = mTime;
	}
	public double getLatitude() {
		return mLatitude;
	}
	public void setLatitude(double mLatitude) {
		this.mLatitude = mLatitude;
	}
	public double getLongitude() {
		return mLongitude;
	}
	public void setLongitude(double mLongitude) {
		this.mLongitude = mLongitude;
	}
	public boolean isHasAltitude() {
		return mHasAltitude;
	}
	public void setHasAltitude(boolean mHasAltitude) {
		this.mHasAltitude = mHasAltitude;
	}
	public double getAltitude() {
		return mAltitude;
	}
	public void setAltitude(double mAltitude) {
		this.mAltitude = mAltitude;
	}
	public boolean isHasSpeed() {
		return mHasSpeed;
	}
	public void setHasSpeed(boolean mHasSpeed) {
		this.mHasSpeed = mHasSpeed;
	}
	public float getSpeed() {
		return mSpeed;
	}
	public void setSpeed(float mSpeed) {
		this.mSpeed = mSpeed;
	}
	public boolean isHasBearing() {
		return mHasBearing;
	}
	public void setHasBearing(boolean mHasBearing) {
		this.mHasBearing = mHasBearing;
	}
	public float getBearing() {
		return mBearing;
	}
	public void setBearing(float mBearing) {
		this.mBearing = mBearing;
	}
	public boolean isHasAccuracy() {
		return mHasAccuracy;
	}
	public void setHasAccuracy(boolean mHasAccuracy) {
		this.mHasAccuracy = mHasAccuracy;
	}
	public float getAccuracy() {
		return mAccuracy;
	}
	public void setAccuracy(float mAccuracy) {
		this.mAccuracy = mAccuracy;
	}
}
