/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.design;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.customvisualization.CVComponent;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.BaseComponentContext;
import net.sf.jasperreports.engine.component.ComponentContext;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class CVDesignComponent
implements CVComponent,
JRChangeEventsSupport {
    public static final long serialVersionUID = 1L;
    public static final String PROPERTY_ITEM_PROPERTIES = "itemProperties";
    public static final String PROPERTY_ITEM_DATA = "itemData";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_PROCESSING_CLASS = "processingClass";
    public static final String PROPERTY_ON_ERROR_TYPE = "onErrorType";
    private ComponentContext context;
    private transient JRPropertyChangeSupport eventSupport;
    private EvaluationTimeEnum evaluationTime = EvaluationTimeEnum.NOW;
    private String evaluationGroup;
    private List<ItemProperty> itemProperties = new ArrayList<ItemProperty>();
    private List<ItemData> itemDataList = new ArrayList<ItemData>();
    private String processingClass;
    private OnErrorTypeEnum onErrorType = OnErrorTypeEnum.ERROR;

    public CVDesignComponent() {
    }

    public CVDesignComponent(CVComponent component, JRBaseObjectFactory baseFactory) {
        this.evaluationTime = component.getEvaluationTime();
        this.evaluationGroup = component.getEvaluationGroup();
        this.processingClass = component.getProcessingClass();
        this.onErrorType = component.getOnErrorType();
        for (ItemProperty prop : component.getItemProperties()) {
            this.addItemProperty((ItemProperty)new StandardItemProperty(prop.getName(), prop.getValue(), baseFactory.getExpression(prop.getValueExpression())));
        }
        for (ItemData itemData : component.getItemData()) {
            this.addItemData((ItemData)new StandardItemData(itemData, baseFactory));
        }
        this.context = new BaseComponentContext(component.getContext(), baseFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        CVDesignComponent cVDesignComponent = this;
        synchronized (cVDesignComponent) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport((Object)this);
            }
        }
        return this.eventSupport;
    }

    public Object clone() {
        CVDesignComponent clone = null;
        try {
            clone = (CVDesignComponent)super.clone();
            clone.itemProperties = JRCloneUtils.cloneList(this.itemProperties);
            clone.itemDataList = JRCloneUtils.cloneList(this.itemDataList);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    @Override
    public EvaluationTimeEnum getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTimeValue) {
        EvaluationTimeEnum old = this.evaluationTime;
        this.evaluationTime = evaluationTimeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, (Object)old, (Object)this.evaluationTime);
    }

    @Override
    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(String evaluationGroup) {
        String old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, (Object)old, (Object)this.evaluationGroup);
    }

    @Override
    public OnErrorTypeEnum getOnErrorType() {
        return this.onErrorType;
    }

    public void setOnErrorType(OnErrorTypeEnum onErrorType) {
        OnErrorTypeEnum old = this.onErrorType;
        this.onErrorType = onErrorType;
        this.getEventSupport().firePropertyChange(PROPERTY_ON_ERROR_TYPE, (Object)old, (Object)this.onErrorType);
    }

    @Override
    public List<ItemProperty> getItemProperties() {
        return this.itemProperties;
    }

    public void addItemProperty(ItemProperty property) {
        this.itemProperties.add(property);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_ITEM_PROPERTIES, (Object)property, this.itemProperties.size() - 1);
    }

    public void removeItemProperty(ItemProperty property) {
        int idx = this.itemProperties.indexOf(property);
        if (idx >= 0) {
            this.itemProperties.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_ITEM_PROPERTIES, (Object)property, idx);
        }
    }

    @Override
    public List<ItemData> getItemData() {
        return this.itemDataList;
    }

    public void addItemData(ItemData data) {
        this.itemDataList.add(data);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_ITEM_DATA, (Object)data, this.itemDataList.size() - 1);
    }

    public void removeItemData(ItemData dataset) {
        int idx = this.itemDataList.indexOf(dataset);
        if (idx >= 0) {
            this.itemDataList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_ITEM_DATA, (Object)dataset, idx);
        }
    }

    @Override
    public String getProcessingClass() {
        return this.processingClass;
    }

    public void setProcessingClass(String processingClass) {
        String old = this.processingClass;
        this.processingClass = processingClass;
        this.getEventSupport().firePropertyChange(PROPERTY_PROCESSING_CLASS, (Object)old, (Object)this.processingClass);
    }

    public void setContext(ComponentContext context) {
        this.context = context;
    }

    public ComponentContext getContext() {
        return this.context;
    }
}

