/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.export;

import net.sf.jasperreports.customvisualization.export.CVElementImageProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.GenericElementXlsxHandler;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporterContext;
import net.sf.jasperreports.repo.RepositoryContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CVElementXlsxHandler
implements GenericElementXlsxHandler {
    private static final CVElementXlsxHandler INSTANCE = new CVElementXlsxHandler();
    private static final Log log = LogFactory.getLog(CVElementXlsxHandler.class);

    public static CVElementXlsxHandler getInstance() {
        return INSTANCE;
    }

    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    public void exportElement(JRXlsxExporterContext exporterContext, JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting to XLSX " + element));
        }
        try {
            RepositoryContext repositoryContext = exporterContext.getRepository().getRepositoryContext();
            JRPrintImage chartImage = CVElementImageProvider.getInstance().getImage(repositoryContext, element);
            JRXlsxExporter exporter = (JRXlsxExporter)exporterContext.getExporterRef();
            exporter.exportImage(chartImage, gridCell, colIndex, rowIndex, 0, 0, null);
        }
        catch (Exception e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    public JRPrintImage getImage(JRXlsxExporterContext jrxec, JRGenericPrintElement jrgpe) throws JRException {
        RepositoryContext repositoryContext = jrxec.getRepository().getRepositoryContext();
        return CVElementImageProvider.getInstance().getImage(repositoryContext, jrgpe);
    }
}

