/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.j2ee.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.j2ee.web.WebResourceHandler;
import net.sf.jasperreports.j2ee.web.WebUtil;
import net.sf.jasperreports.web.util.ContentTypeMapping;
import net.sf.jasperreports.web.util.ResourcePathUtil;
import net.sf.jasperreports.web.util.WebResource;

public abstract class AbstractWebResourceHandler
implements WebResourceHandler {
    @Override
    public boolean handleResource(JasperReportsContext jasperReportsContext, HttpServletRequest request, HttpServletResponse response) {
        WebResource resource;
        WebUtil webUtil = WebUtil.getInstance(jasperReportsContext);
        String resourceUri = webUtil.getResourceUri(request);
        if (resourceUri == null) {
            int resourceUriStart;
            String requestUrl = null;
            try {
                requestUrl = URLDecoder.decode(request.getRequestURL().toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new JRRuntimeException((Throwable)e);
            }
            String servletPath = ResourcePathUtil.getInstance((JasperReportsContext)jasperReportsContext).getResourcesPath();
            int uriStart = requestUrl.indexOf(servletPath);
            if (uriStart >= 0 && (resourceUriStart = uriStart + servletPath.length() + 1) < requestUrl.length()) {
                resourceUri = requestUrl.substring(resourceUriStart);
            }
        }
        if (resourceUri != null && resourceUri.trim().length() > 0 && (resource = this.getResource(jasperReportsContext, request, resourceUri)) != null) {
            boolean corsHeaderAllowAll;
            String resourceType = resource.getType();
            if (resourceType != null) {
                List contentTypeMappings = jasperReportsContext.getExtensions(ContentTypeMapping.class);
                for (ContentTypeMapping contentTypeMapping : contentTypeMappings) {
                    if (!resourceType.equals(contentTypeMapping.getFileType())) continue;
                    response.setContentType(contentTypeMapping.getContentType());
                    break;
                }
            }
            if (corsHeaderAllowAll = JRPropertiesUtil.getInstance((JasperReportsContext)jasperReportsContext).getBooleanProperty("net.sf.jasperreports.web.resource.cors.header.allow.origin.all", true)) {
                response.setHeader("Access-Control-Allow-Origin", "*");
            }
            response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            response.addHeader("Cache-Control", "post-check=0, pre-check=0");
            response.setHeader("Pragma", "no-cache");
            byte[] bytes = resource.getData();
            response.setContentLength(bytes.length);
            ServletOutputStream os = null;
            try {
                os = response.getOutputStream();
                os.write(bytes);
            }
            catch (IOException e) {
                throw new JRRuntimeException((Throwable)e);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return true;
        }
        return false;
    }

    public abstract WebResource getResource(JasperReportsContext var1, HttpServletRequest var2, String var3);
}

