/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.j2ee.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.j2ee.web.AbstractWebResourceHandler;
import net.sf.jasperreports.j2ee.web.LocaleResolverUtil;
import net.sf.jasperreports.velocity.util.VelocityUtil;
import net.sf.jasperreports.web.util.ResourcePathUtil;
import net.sf.jasperreports.web.util.SimpleWebResource;
import net.sf.jasperreports.web.util.WebResource;

public class JiveWebResourceHandler
extends AbstractWebResourceHandler {
    private String bundleName;
    private Map<String, String> keyToFileMappings;

    public JiveWebResourceHandler(String bundleName) {
        this.bundleName = bundleName;
        this.keyToFileMappings = new HashMap<String, String>();
    }

    @Override
    public WebResource getResource(JasperReportsContext jasperReportsContext, HttpServletRequest request, String resourceKey) {
        SimpleWebResource resource = null;
        if (resourceKey != null && this.keyToFileMappings.containsKey(resourceKey)) {
            byte[] bytes = null;
            try {
                Locale locale = LocaleResolverUtil.instance(jasperReportsContext).getLocale(request);
                HashMap<String, String> contextMap = new HashMap<String, String>();
                contextMap.put("path", request.getContextPath() + ResourcePathUtil.getInstance((JasperReportsContext)jasperReportsContext).getResourcesBasePath());
                contextMap.put("msgProvider", (String)MessageUtil.getInstance((JasperReportsContext)jasperReportsContext).getLocalizedMessageProvider(this.bundleName, locale));
                String resourceString = VelocityUtil.processTemplate((String)this.keyToFileMappings.get(resourceKey), contextMap);
                if (resourceString != null) {
                    bytes = resourceString.getBytes("UTF-8");
                }
            }
            catch (IOException e) {
                throw new JRRuntimeException((Throwable)e);
            }
            resource = new SimpleWebResource();
            resource.setData(bytes);
            if (resourceKey != null && resourceKey.lastIndexOf(".") != -1) {
                resource.setType(resourceKey.substring(resourceKey.lastIndexOf(".") + 1));
            }
        }
        return resource;
    }

    public void addMapping(String key, String fileClasspath) {
        this.keyToFileMappings.put(key, fileClasspath);
    }
}

