/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.j2ee.web;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRDataUtils;

public final class WebUtil {
    private JRPropertiesUtil propertiesUtil;

    private WebUtil(JasperReportsContext jasperReportsContext) {
        this.propertiesUtil = JRPropertiesUtil.getInstance((JasperReportsContext)jasperReportsContext);
    }

    public static WebUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new WebUtil(jasperReportsContext);
    }

    public String getResourceUri(HttpServletRequest request) {
        String resourceUriParamName = this.propertiesUtil.getProperty("net.sf.jasperreports.web.request.parameter.resource.uri");
        return request.getParameter(resourceUriParamName);
    }

    public Locale getResourceLocale(HttpServletRequest request) {
        String resourceLocaleParamName = this.propertiesUtil.getProperty("net.sf.jasperreports.web.request.parameter.resource.locale");
        String localeCode = request.getParameter(resourceLocaleParamName);
        return localeCode == null ? null : JRDataUtils.getLocale((String)localeCode);
    }

    public String getResourceBundleForResource(HttpServletRequest request) {
        String resourceBundleParamName = this.propertiesUtil.getProperty("net.sf.jasperreports.web.request.parameter.resource.bundle");
        return request.getParameter(resourceBundleParamName);
    }

    public boolean isDynamicResource(HttpServletRequest request) {
        String dynamicResourceParamName = this.propertiesUtil.getProperty("net.sf.jasperreports.web.request.parameter.dynamic.resource");
        return Boolean.parseBoolean(request.getParameter(dynamicResourceParamName));
    }
}

