/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.beans;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.javagimmicks.beans.BeanUtils;

public class BeanPropertyComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 2201059572853849944L;
    protected List<String> _beanProperties;
    protected Map<String, SortOrder> _sortOrders = new HashMap<String, SortOrder>();

    public BeanPropertyComparator(String ... propertyNames) {
        this(Arrays.asList(propertyNames));
    }

    public BeanPropertyComparator(List<String> propertyNames) {
        this._beanProperties = new ArrayList<String>(propertyNames);
    }

    public BeanPropertyComparator(List<String> propertyNames, Map<String, SortOrder> sortOrders) {
        this(propertyNames);
        if (sortOrders != null) {
            this._sortOrders.putAll(sortOrders);
        }
    }

    public BeanPropertyComparator(List<String> propertyNames, List<SortOrder> sortOrders) {
        if (sortOrders.size() != propertyNames.size()) {
            throw new IllegalArgumentException("Number of properties and sort orders must match!");
        }
        this._beanProperties = new ArrayList<String>(propertyNames.size());
        Iterator<String> iterPropertyNames = propertyNames.iterator();
        Iterator<SortOrder> itersortOrders = sortOrders.iterator();
        while (iterPropertyNames.hasNext()) {
            String propertyName = iterPropertyNames.next();
            SortOrder sortOrder = itersortOrders.next();
            this._beanProperties.add(propertyName);
            this._sortOrders.put(propertyName, sortOrder);
        }
    }

    public BeanPropertyComparator(Class<? extends T> beanClass) {
        this._beanProperties = BeanUtils.extractPropertyNames(beanClass);
    }

    public BeanPropertyComparator() {
        this._beanProperties = Collections.emptyList();
    }

    public List<String> getBeanPropertyNames() {
        return Collections.unmodifiableList(this._beanProperties);
    }

    public void setBeanPropertyNames(List<String> beanProperties) {
        this._beanProperties = new ArrayList<String>(beanProperties);
    }

    public SortOrder getSortOrder(String propertyName) {
        if (!this._beanProperties.contains(propertyName)) {
            return SortOrder.NONE;
        }
        SortOrder result = this._sortOrders.get(propertyName);
        return result != null ? result : SortOrder.ASCENDING;
    }

    public void setSortOrder(String propertyName, SortOrder sortOrder) {
        if (sortOrder == SortOrder.NONE || sortOrder == null) {
            this._sortOrders.remove(propertyName);
            this._beanProperties.remove(propertyName);
        } else {
            if (!this._beanProperties.contains(propertyName)) {
                this._beanProperties.add(propertyName);
            }
            this._sortOrders.put(propertyName, sortOrder);
        }
    }

    @Override
    public int compare(T o1, T o2) {
        for (String propertyName : this._beanProperties) {
            Object propertyValue2;
            Object propertyValue1;
            try {
                propertyValue1 = this.invokeGetter(o1, propertyName);
                propertyValue2 = this.invokeGetter(o2, propertyName);
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException("Error invoking bean getter for property '" + propertyName + "'!", ex);
            }
            int result = ((Comparable)propertyValue1).compareTo(propertyValue2);
            if (result == 0) continue;
            SortOrder sortOrder = this.getSortOrder(propertyName);
            if (sortOrder == SortOrder.DESCENDING) {
                result *= -1;
            }
            return result;
        }
        return 0;
    }

    protected Object invokeGetter(Object target, String propertyName) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = target.getClass().getMethod("get" + propertyName, new Class[0]);
        return m.invoke(target, new Object[0]);
    }

    public static enum SortOrder {
        ASCENDING,
        DESCENDING,
        NONE;

    }
}

