/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.beans;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class BeanUtils {
    public static List<String> extractPropertyNames(Class<?> beanClass) {
        ArrayList<String> result = new ArrayList<String>();
        for (Method m : beanClass.getMethods()) {
            String methodName = m.getName();
            if (m.getParameterTypes().length != 0 || !Modifier.isPublic(m.getModifiers())) continue;
            if (methodName.length() > 2 && methodName.startsWith("is") && (m.getReturnType().equals(Boolean.TYPE) || m.getReturnType().equals(Boolean.class))) {
                result.add(methodName.substring(2));
                continue;
            }
            if (methodName.length() <= 3 || !methodName.startsWith("get") || m.getReturnType().equals(Void.TYPE) || "getClass".equals(methodName)) continue;
            result.add(methodName.substring(3));
        }
        return result;
    }

    public static Class<?> getWrapperType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Character.TYPE.equals(type)) {
            return Character.class;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        return type;
    }
}

