/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMap2<K, V>
extends AbstractMap<K, V> {
    @Override
    public abstract Set<K> keySet();

    protected abstract V getValue(K var1);

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<K> keySet = this.keySet();
        return new EntrySetProxy(keySet);
    }

    protected final class EntryProxy
    implements Map.Entry<K, V> {
        protected final K _key;
        protected final V _value;

        private EntryProxy(K key, V value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public V setValue(V value) {
            AbstractMap2.this.put(this._key, value);
            return this._value;
        }
    }

    protected class EntryIteratorProxy
    implements Iterator<Map.Entry<K, V>> {
        protected final Iterator<K> _keyIterator;

        protected EntryIteratorProxy(Iterator<K> keyIterator) {
            this._keyIterator = keyIterator;
        }

        @Override
        public boolean hasNext() {
            return this._keyIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Object key = this._keyIterator.next();
            Object value = AbstractMap2.this.getValue(key);
            return new EntryProxy(key, value);
        }

        @Override
        public void remove() {
            this._keyIterator.remove();
        }
    }

    protected class EntrySetProxy
    extends AbstractSet<Map.Entry<K, V>> {
        protected final Set<K> _keySet;

        protected EntrySetProxy(Set<K> keySet) {
            this._keySet = keySet;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            Iterator keyIterator = this._keySet.iterator();
            return new EntryIteratorProxy(keyIterator);
        }

        @Override
        public int size() {
            return this._keySet.size();
        }
    }
}

