/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import net.sf.javagimmicks.collections.AbstractTraverser;
import net.sf.javagimmicks.collections.Ring;

public abstract class AbstractRing<E>
extends AbstractCollection<E>
implements Ring<E> {
    protected int _modCount = Integer.MIN_VALUE;

    @Override
    public boolean add(E value) {
        this.traverser().insertBefore(value);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.traverser().insertBefore(collection);
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return this.traverser().iterator();
    }

    @Override
    public String toString() {
        return this.traverser().toString();
    }

    protected static abstract class BasicTraverser<E, R extends AbstractRing<E>>
    extends AbstractTraverser<E> {
        protected final R _ring;
        protected int _expectedModCount;

        protected BasicTraverser(R ring) {
            this._ring = ring;
            this._expectedModCount = ((AbstractRing)this._ring)._modCount;
        }

        public R ring() {
            return this._ring;
        }

        protected void checkForModification() {
            if (((AbstractRing)this._ring)._modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

