/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.javagimmicks.collections.Traverser;

public abstract class AbstractTraverser<E>
implements Traverser<E> {
    @Override
    public void insertAfter(Collection<? extends E> collection) {
        for (E value : collection) {
            this.insertAfter(value);
            this.next();
        }
        this.previous(collection.size());
    }

    @Override
    public void insertBefore(Collection<? extends E> collection) {
        for (E value : collection) {
            this.insertBefore(value);
        }
    }

    @Override
    public E next(int count) {
        if (count < 0) {
            return this.previous(-count);
        }
        if (count == 0) {
            return this.get();
        }
        int ringSize = this.ring().size();
        if ((count %= ringSize) > ringSize / 2) {
            return this.previous(ringSize - count);
        }
        E result = null;
        for (int i = 0; i < count; ++i) {
            result = this.next();
        }
        return result;
    }

    @Override
    public E previous(int count) {
        if (count < 0) {
            return this.next(-count);
        }
        if (count == 0) {
            return this.get();
        }
        int ringSize = this.ring().size();
        if ((count %= ringSize) > ringSize / 2) {
            return this.next(ringSize - count);
        }
        E result = null;
        for (int i = 0; i < count; ++i) {
            result = this.previous();
        }
        return result;
    }

    @Override
    public E set(E value) {
        this.insertAfter(value);
        return this.remove();
    }

    @Override
    public Iterator<E> iterator() {
        return new RingIterator(this.traverser());
    }

    @Override
    public List<E> toList() {
        ArrayList<E> result = new ArrayList<E>(this.ring().size());
        for (E element : this) {
            result.add(element);
        }
        return result;
    }

    public String toString() {
        return this.toList().toString();
    }

    protected static class RingIterator<E>
    implements Iterator<E> {
        private final Traverser<E> _traverser;
        private final int _size;
        private int _counter = 0;
        private boolean _removeCalled = true;

        public RingIterator(Traverser<E> traverser) {
            this._traverser = traverser;
            this._traverser.previous();
            this._size = traverser.ring().size();
        }

        @Override
        public boolean hasNext() {
            return this._counter != this._size;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._removeCalled = false;
            ++this._counter;
            return this._traverser.next();
        }

        @Override
        public void remove() {
            if (this._removeCalled) {
                throw new IllegalStateException("next() has not yet been called since last remove() call or creation of this iterator!");
            }
            this._removeCalled = true;
            this._traverser.remove();
            if (!this._traverser.ring().isEmpty()) {
                this._traverser.previous();
            }
        }
    }
}

