/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import net.sf.javagimmicks.collections.AbstractRing;
import net.sf.javagimmicks.collections.Traverser;

public class ArrayRing<E>
extends AbstractRing<E> {
    private final ArrayList<E> _backingList;

    public ArrayRing() {
        this._backingList = new ArrayList();
    }

    public ArrayRing(int initialCapacity) {
        this._backingList = new ArrayList(initialCapacity);
    }

    @Override
    public int size() {
        return this._backingList.size();
    }

    @Override
    public Traverser<E> traverser() {
        return new ArrayTraverser(this, 0);
    }

    public void ensureCapacity(int minCapacity) {
        this._backingList.ensureCapacity(minCapacity);
    }

    private static class ArrayTraverser<E>
    extends AbstractRing.BasicTraverser<E, ArrayRing<E>> {
        private int _position;

        private ArrayTraverser(ArrayRing<E> ring, int position) {
            super(ring);
            this._position = position;
        }

        @Override
        public E get() {
            this.checkForModification();
            if (((ArrayRing)this._ring)._backingList.isEmpty()) {
                throw new NoSuchElementException();
            }
            return ((ArrayRing)this._ring)._backingList.get(this._position);
        }

        @Override
        public void insertAfter(E value) {
            this.checkForModification();
            if (((ArrayRing)this._ring).isEmpty()) {
                ((ArrayRing)this._ring)._backingList.add(value);
            } else {
                ((ArrayRing)this._ring)._backingList.add(this._position + 1, value);
            }
            ++((ArrayRing)this._ring)._modCount;
            ++this._expectedModCount;
        }

        @Override
        public void insertBefore(E value) {
            this.checkForModification();
            if (this._position == 0) {
                ((ArrayRing)this._ring)._backingList.add(value);
            } else {
                ((ArrayRing)this._ring)._backingList.add(this._position, value);
                ++this._position;
            }
            ++((ArrayRing)this._ring)._modCount;
            ++this._expectedModCount;
        }

        @Override
        public E next() {
            this.checkForModification();
            if (((ArrayRing)this._ring).isEmpty()) {
                throw new NoSuchElementException("Ring is empty");
            }
            ++this._position;
            if (this._position == ((ArrayRing)this._ring).size()) {
                this._position = 0;
            }
            return this.get();
        }

        @Override
        public E previous() {
            this.checkForModification();
            if (((ArrayRing)this._ring).isEmpty()) {
                throw new NoSuchElementException("Ring is empty");
            }
            --this._position;
            if (this._position == -1) {
                this._position += ((ArrayRing)this._ring).size();
            }
            return this.get();
        }

        @Override
        public E remove() {
            this.checkForModification();
            if (((ArrayRing)this._ring).isEmpty()) {
                throw new NoSuchElementException("Ring is empty");
            }
            Object result = ((ArrayRing)this._ring)._backingList.remove(this._position);
            ++((ArrayRing)this._ring)._modCount;
            ++this._expectedModCount;
            return result;
        }

        @Override
        public Traverser<E> traverser() {
            return new ArrayTraverser<E>((ArrayRing)this._ring, this._position);
        }
    }
}

