/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static <E> List<E> asList(E ... array) {
        return Arrays.asList(array);
    }

    public static List<Integer> asList(final int ... array) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return array[index];
            }

            @Override
            public Integer set(int index, Integer element) {
                int result = array[index];
                array[index] = element;
                return result;
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static List<Long> asList(final long ... array) {
        return new AbstractList<Long>(){

            @Override
            public Long get(int index) {
                return array[index];
            }

            @Override
            public Long set(int index, Long element) {
                long result = array[index];
                array[index] = element;
                return result;
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static List<Byte> asList(final byte ... array) {
        return new AbstractList<Byte>(){

            @Override
            public Byte get(int index) {
                return array[index];
            }

            @Override
            public Byte set(int index, Byte element) {
                byte result = array[index];
                array[index] = element;
                return result;
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static List<Short> asList(final short ... array) {
        return new AbstractList<Short>(){

            @Override
            public Short get(int index) {
                return array[index];
            }

            @Override
            public Short set(int index, Short element) {
                short result = array[index];
                array[index] = element;
                return result;
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static List<Float> asList(final float ... array) {
        return new AbstractList<Float>(){

            @Override
            public Float get(int index) {
                return Float.valueOf(array[index]);
            }

            @Override
            public Float set(int index, Float element) {
                float result = array[index];
                array[index] = element.floatValue();
                return Float.valueOf(result);
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static List<Double> asList(final double ... array) {
        return new AbstractList<Double>(){

            @Override
            public Double get(int index) {
                return array[index];
            }

            @Override
            public Double set(int index, Double element) {
                double result = array[index];
                array[index] = element;
                return result;
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static List<Boolean> asList(final boolean ... array) {
        return new AbstractList<Boolean>(){

            @Override
            public Boolean get(int index) {
                return array[index];
            }

            @Override
            public Boolean set(int index, Boolean element) {
                boolean result = array[index];
                array[index] = element;
                return result;
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static List<Character> asList(final char ... array) {
        return new AbstractList<Character>(){

            @Override
            public Character get(int index) {
                return Character.valueOf(array[index]);
            }

            @Override
            public Character set(int index, Character element) {
                char result = array[index];
                array[index] = element.charValue();
                return Character.valueOf(result);
            }

            @Override
            public int size() {
                return array.length;
            }
        };
    }

    public static Integer[] wrap(int ... array) {
        return ArrayUtils.asList(array).toArray(new Integer[0]);
    }

    public static Long[] wrap(long ... array) {
        return ArrayUtils.asList(array).toArray(new Long[0]);
    }

    public static Byte[] wrap(byte ... array) {
        return ArrayUtils.asList(array).toArray(new Byte[0]);
    }

    public static Short[] wrap(short ... array) {
        return ArrayUtils.asList(array).toArray(new Short[0]);
    }

    public static Float[] wrap(float ... array) {
        return ArrayUtils.asList(array).toArray(new Float[0]);
    }

    public static Double[] wrap(double ... array) {
        return ArrayUtils.asList(array).toArray(new Double[0]);
    }

    public static Boolean[] wrap(boolean ... array) {
        return ArrayUtils.asList(array).toArray(new Boolean[0]);
    }

    public static Character[] wrap(char ... array) {
        return ArrayUtils.asList(array).toArray(new Character[0]);
    }
}

