/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import net.sf.javagimmicks.collections.decorators.AbstractQueueDecorator;

public class AutoSkippingQueueDecorator<E>
extends AbstractQueueDecorator<E> {
    private static final long serialVersionUID = 8775576852585456548L;
    private final int _maxSize;
    private final int _skipCount;

    public AutoSkippingQueueDecorator(Queue<E> decorated, int maxSize, int skipCount) {
        super(decorated);
        if (maxSize < 1) {
            throw new IllegalArgumentException("Max size must be 1 or greater!");
        }
        if (skipCount < 1) {
            throw new IllegalArgumentException("Skip count must be 1 or greater!");
        }
        if (skipCount > maxSize) {
            throw new IllegalArgumentException("Skip count mustn't be greater than max size!");
        }
        this._maxSize = maxSize;
        this._skipCount = skipCount;
    }

    public AutoSkippingQueueDecorator(Queue<E> internalQueue, int maxSize) {
        this(internalQueue, maxSize, maxSize);
    }

    public AutoSkippingQueueDecorator(int maxSize, int skipCount) {
        this(new LinkedList(), maxSize, skipCount);
    }

    public AutoSkippingQueueDecorator(int maxSize) {
        this(maxSize, maxSize);
    }

    @Override
    public boolean add(E o) {
        boolean changed;
        boolean bl = changed = this.size() == this._maxSize;
        if (changed) {
            if (this._skipCount == this._maxSize) {
                this.clear();
            } else {
                for (int i = this._skipCount; i > 0; --i) {
                    this.remove();
                }
            }
        }
        return this.getDecorated().add(o) || changed;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E element : c) {
            changed |= this.add(element);
        }
        return changed;
    }

    @Override
    public boolean offer(E o) {
        return this.add(o);
    }
}

