/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections;

import java.util.NoSuchElementException;
import net.sf.javagimmicks.collections.AbstractRing;
import net.sf.javagimmicks.collections.Traverser;

public class LinkedRing<E>
extends AbstractRing<E> {
    private int _size = 0;
    private RingElement<E> _hook = null;

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public Traverser<E> traverser() {
        return new LinkedTraverser(this, this._hook);
    }

    private static class LinkedTraverser<E>
    extends AbstractRing.BasicTraverser<E, LinkedRing<E>> {
        private RingElement<E> _current;

        private LinkedTraverser(LinkedRing<E> ring, RingElement<E> current) {
            super(ring);
            this._current = current;
        }

        @Override
        public E get() {
            if (this._current == null) {
                throw new NoSuchElementException("Ring is empty");
            }
            return (E)((RingElement)this._current)._value;
        }

        @Override
        public void insertAfter(E value) {
            RingElement next = this._current != null ? ((RingElement)this._current)._next : null;
            this.insert(value, this._current, next);
        }

        @Override
        public void insertBefore(E value) {
            RingElement previous = this._current != null ? ((RingElement)this._current)._previous : null;
            this.insert(value, previous, this._current);
        }

        @Override
        public E next() {
            this.checkForModification();
            if (this._current == null) {
                throw new NoSuchElementException("Ring is empty");
            }
            this._current = ((RingElement)this._current)._next;
            return this.get();
        }

        @Override
        public E previous() {
            this.checkForModification();
            if (this._current == null) {
                throw new NoSuchElementException("Ring is empty");
            }
            this._current = ((RingElement)this._current)._previous;
            return this.get();
        }

        @Override
        public E remove() {
            this.checkForModification();
            int ringSize = ((LinkedRing)this._ring)._size;
            if (ringSize == 0) {
                throw new NoSuchElementException();
            }
            Object result = ((RingElement)this._current)._value;
            if (ringSize == 1) {
                ((RingElement)this._current)._next = null;
                ((RingElement)this._current)._previous = null;
                this._current = null;
                ((LinkedRing)this._ring)._hook = null;
            } else {
                RingElement nextElement = ((RingElement)this._current)._next;
                RingElement previousElement = ((RingElement)this._current)._previous;
                nextElement._previous = previousElement;
                previousElement._next = nextElement;
                ((RingElement)this._current)._next = null;
                ((RingElement)this._current)._previous = null;
                if (((LinkedRing)this._ring)._hook == this._current) {
                    ((LinkedRing)this._ring)._hook = nextElement;
                }
                this._current = nextElement;
            }
            --((LinkedRing)this._ring)._size;
            ++((LinkedRing)this._ring)._modCount;
            ++this._expectedModCount;
            return (E)result;
        }

        @Override
        public Traverser<E> traverser() {
            return new LinkedTraverser<E>((LinkedRing)this._ring, this._current);
        }

        private void insert(E value, RingElement<E> previous, RingElement<E> next) {
            this.checkForModification();
            RingElement newElement = new RingElement();
            newElement._value = value;
            if (previous == null || next == null) {
                newElement._previous = newElement;
                newElement._next = newElement;
                this._current = newElement;
                ((LinkedRing)this._ring)._hook = newElement;
            } else {
                newElement._previous = (RingElement)previous;
                newElement._next = (RingElement)next;
                ((RingElement)previous)._next = newElement;
                ((RingElement)next)._previous = newElement;
            }
            ++((LinkedRing)this._ring)._size;
            ++((LinkedRing)this._ring)._modCount;
            ++this._expectedModCount;
        }
    }

    private static class RingElement<E> {
        private RingElement<E> _previous;
        private RingElement<E> _next;
        private E _value;

        private RingElement() {
        }
    }
}

