/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.javagimmicks.util.ComparableComparator;

public class ListComparator<E>
implements Comparator<List<E>> {
    private final Comparator<E> _elementComparator;
    public static ListComparator<? extends Comparable<?>> COMPARABLE_INSTANCE = new ListComparator(ComparableComparator.INSTANCE);

    public ListComparator(Comparator<E> elementComparator) {
        this._elementComparator = elementComparator;
    }

    public static <E extends Comparable<? super E>> ListComparator<E> getComparableInstance() {
        return COMPARABLE_INSTANCE;
    }

    @Override
    public int compare(List<E> list1, List<E> list2) {
        Iterator<E> iterator1 = list1.iterator();
        Iterator<E> iterator2 = list2.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            E element2;
            E element1 = iterator1.next();
            int iCompareResult = this._elementComparator.compare(element1, element2 = iterator2.next());
            if (iCompareResult == 0) continue;
            return iCompareResult;
        }
        if (iterator1.hasNext()) {
            return -1;
        }
        if (iterator2.hasNext()) {
            return 1;
        }
        return 0;
    }
}

