/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ReverseList<E>
extends AbstractList<E> {
    protected final List<E> _internalList;

    public static <E> ReverseList<E> decorate(List<E> list) {
        return new ReverseList<E>(list);
    }

    protected ReverseList(List<E> decorated) {
        this._internalList = decorated;
    }

    public List<E> getInternalList() {
        return this._internalList;
    }

    @Override
    public boolean add(E e) {
        this._internalList.add(0, e);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this._internalList.add(this.getRevertedIndex(index) + 1, element);
    }

    @Override
    public void clear() {
        this._internalList.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this._internalList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._internalList.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this._internalList.get(this.getRevertedIndex(index));
    }

    @Override
    public int indexOf(Object o) {
        return this._internalList.lastIndexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this._internalList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this._internalList.indexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new RevertingListIteratorDecorator(this._internalList.listIterator(this.getRevertedIndex(index) + 1));
    }

    @Override
    public E remove(int index) {
        return this._internalList.remove(this.getRevertedIndex(index));
    }

    @Override
    public boolean remove(Object o) {
        return this._internalList.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this._internalList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this._internalList.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        return this._internalList.set(this.getRevertedIndex(index), element);
    }

    @Override
    public int size() {
        return this._internalList.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new ReverseList<E>(this._internalList.subList(this.getRevertedIndex(toIndex) + 1, this.getRevertedIndex(fromIndex) + 1));
    }

    protected int getRevertedIndex(int index) {
        return this.size() - index - 1;
    }

    protected class RevertingListIteratorDecorator
    implements ListIterator<E> {
        protected final ListIterator<E> _internalIterator;

        public RevertingListIteratorDecorator(ListIterator<E> decorated) {
            this._internalIterator = decorated;
        }

        @Override
        public void add(E e) {
            this._internalIterator.add(e);
            this._internalIterator.previous();
        }

        @Override
        public boolean hasNext() {
            return this._internalIterator.hasPrevious();
        }

        @Override
        public boolean hasPrevious() {
            return this._internalIterator.hasNext();
        }

        @Override
        public E next() {
            return this._internalIterator.previous();
        }

        @Override
        public int nextIndex() {
            return ReverseList.this.getRevertedIndex(this._internalIterator.previousIndex());
        }

        @Override
        public E previous() {
            return this._internalIterator.next();
        }

        @Override
        public int previousIndex() {
            return ReverseList.this.getRevertedIndex(this._internalIterator.nextIndex());
        }

        @Override
        public void remove() {
            this._internalIterator.remove();
        }

        @Override
        public void set(E e) {
            this._internalIterator.set(e);
        }
    }
}

