/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import net.sf.javagimmicks.collections.decorators.AbstractListDecorator;
import net.sf.javagimmicks.collections.decorators.AbstractListIteratorDecorator;
import net.sf.javagimmicks.util.ComparableComparator;

public class SortedListUtils {
    public static <T extends Comparable<? super T>> int getInsertIndex(List<T> list, T element) {
        int index = Collections.binarySearch(list, element);
        if (index < 0) {
            index = -index - 1;
        }
        return index;
    }

    public static <T> int getInsertIndex(List<T> list, T element, Comparator<? super T> comparator) {
        int index = Collections.binarySearch(list, element, comparator);
        if (index < 0) {
            index = -index - 1;
        }
        return index;
    }

    public static <T extends Comparable<? super T>> void addSorted(List<T> list, T element) {
        list.add(SortedListUtils.getInsertIndex(list, element), element);
    }

    public static <T> void addSorted(List<T> list, T element, Comparator<? super T> comparator) {
        list.add(SortedListUtils.getInsertIndex(list, element, comparator), element);
    }

    public static <T extends Comparable<? super T>> List<T> decorate(List<T> list) {
        ComparableComparator<? extends Comparable<?>> comparableComparator = ComparableComparator.INSTANCE;
        return new SortedListDecorator(list, comparableComparator);
    }

    public static <T> List<T> decorate(List<T> list, Comparator<? super T> comparator) {
        return new SortedListDecorator<T>(list, comparator);
    }

    public static <T> void resort(List<T> list) {
        if (!(list instanceof SortedListDecorator)) {
            throw new IllegalArgumentException("Provided list is not a decorated sorted list!");
        }
        SortedListDecorator sortedList = (SortedListDecorator)list;
        Collections.sort(sortedList.getDecorated(), sortedList._comparator);
    }

    public static <T> List<T> exchangeComparator(List<T> list, Comparator<? super T> oComparator) {
        if (!(list instanceof SortedListDecorator)) {
            throw new IllegalArgumentException("Provided list is not a decorated sorted list!");
        }
        SortedListDecorator sortedList = (SortedListDecorator)list;
        return new SortedListDecorator<T>(sortedList.getDecorated(), oComparator);
    }

    protected static final class SortedListDecorator<E>
    extends AbstractListDecorator<E> {
        private static final long serialVersionUID = 8756998247400676692L;
        private static final String MSG_ERROR_INDEX = "Cannot insert by index into a sorted list!";
        protected final Comparator<? super E> _comparator;

        protected SortedListDecorator(List<E> decorated, Comparator<? super E> comparator) {
            super(decorated);
            this._comparator = comparator;
            Collections.sort(decorated, this._comparator);
        }

        @Override
        public boolean add(E element) {
            SortedListUtils.addSorted(this.getDecorated(), element, this._comparator);
            return true;
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException(MSG_ERROR_INDEX);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            for (E element : collection) {
                this.add(element);
            }
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException(MSG_ERROR_INDEX);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new SortedListIteratorDecorator(this.getDecorated().listIterator());
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new SortedListIteratorDecorator(this.getDecorated().listIterator(index));
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException("Cannot set values by index in a sorted list!");
        }

        @Override
        public SortedListDecorator<E> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Cannot create sub lists of a sorted list!");
        }

        protected class SortedListIteratorDecorator
        extends AbstractListIteratorDecorator<E> {
            public SortedListIteratorDecorator(ListIterator<E> decorated) {
                super(decorated);
            }

            @Override
            public void add(E o) {
                throw new UnsupportedOperationException("Cannot add to a sorted list via a ListIterator!");
            }

            @Override
            public void set(E o) {
                throw new UnsupportedOperationException("Cannot set values in a a sorted list via a ListIterator!");
            }
        }
    }
}

