/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.bidimap;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.javagimmicks.collections.bidimap.BidiMap;

public class DualBidiMap<K, V>
extends AbstractMap<K, V>
implements BidiMap<K, V> {
    protected final Map<K, V> _forwardMap;
    protected final Map<V, K> _reverseMap;

    DualBidiMap(Map<K, V> forwardMap, Map<V, K> reverseMap) {
        this._forwardMap = forwardMap;
        this._reverseMap = reverseMap;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new DualBidiEntrySet(this.getForwardMap().entrySet());
    }

    @Override
    public V put(K key, V value) {
        DualBidiMap.checkValue(value);
        V oldValue = this.getForwardMap().put(key, value);
        K oldKey = this.getReverseMap().put(value, key);
        this.getForwardMap().remove(oldKey);
        this.getReverseMap().remove(oldValue);
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        V value = this.getForwardMap().remove(key);
        this.getReverseMap().remove(value);
        return value;
    }

    @Override
    public BidiMap<V, K> inverseBidiMap() {
        return new InverseDualBidiMap(this.getReverseMap(), this.getForwardMap());
    }

    @Override
    public V get(Object key) {
        return this.getForwardMap().get(key);
    }

    @Override
    public K getKey(V value) {
        return this.getReverseMap().get(value);
    }

    protected Map<K, V> getForwardMap() {
        return this._forwardMap;
    }

    protected Map<V, K> getReverseMap() {
        return this._reverseMap;
    }

    protected static <V> void checkValue(V value) {
        if (value == null) {
            throw new IllegalArgumentException("Null values not allowed in BidiMaps!");
        }
    }

    protected class InverseDualBidiMap
    extends DualBidiMap<V, K> {
        protected InverseDualBidiMap(Map<V, K> reverseMap, Map<K, V> forwardMap) {
            super(reverseMap, forwardMap);
        }

        @Override
        public BidiMap<K, V> inverseBidiMap() {
            return DualBidiMap.this;
        }
    }

    protected class DualBidiEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<K, V>> internalEntrySet;

        protected DualBidiEntrySet(Set<Map.Entry<K, V>> internalEntrySet) {
            this.internalEntrySet = internalEntrySet;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new DualBidiEntryIterator(this.internalEntrySet.iterator());
        }

        @Override
        public int size() {
            return this.internalEntrySet.size();
        }
    }

    protected class DualBidiEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        protected final Iterator<Map.Entry<K, V>> internalIterator;
        protected Map.Entry<K, V> _lastEntry;

        protected DualBidiEntryIterator(Iterator<Map.Entry<K, V>> internalIterator) {
            this.internalIterator = internalIterator;
        }

        @Override
        public boolean hasNext() {
            return this.internalIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this._lastEntry = this.internalIterator.next();
            return new DualBidiEntry(this._lastEntry);
        }

        @Override
        public void remove() {
            this.internalIterator.remove();
            DualBidiMap.this._reverseMap.remove(this._lastEntry.getValue());
        }
    }

    protected class DualBidiEntry
    implements Map.Entry<K, V> {
        protected final Map.Entry<K, V> internalEntry;

        protected DualBidiEntry(Map.Entry<K, V> internalEntry) {
            this.internalEntry = internalEntry;
        }

        @Override
        public K getKey() {
            return this.internalEntry.getKey();
        }

        @Override
        public V getValue() {
            return this.internalEntry.getValue();
        }

        @Override
        public V setValue(V value) {
            return DualBidiMap.this.put(this.getKey(), value);
        }
    }
}

