/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.bidimap;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.sf.javagimmicks.collections.bidimap.DualBidiMap;
import net.sf.javagimmicks.collections.bidimap.SortedBidiMap;

public class DualSortedBidiMap<K, V>
extends DualBidiMap<K, V>
implements SortedBidiMap<K, V> {
    DualSortedBidiMap(SortedMap<K, V> forwardMap, SortedMap<V, K> reverseMap) {
        super(forwardMap, reverseMap);
    }

    @Override
    public SortedBidiMap<V, K> inverseBidiSortedMap() {
        return new InverseDualSortedBidiMap(this.getReverseMap(), this.getForwardMap());
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return new SortedSubMapDecorator(this.getForwardMap().headMap(toKey));
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return new SortedSubMapDecorator(this.getForwardMap().subMap(fromKey, toKey));
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return new SortedSubMapDecorator(this.getForwardMap().tailMap(fromKey));
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.getForwardMap().comparator();
    }

    @Override
    public K firstKey() {
        return this.getForwardMap().firstKey();
    }

    @Override
    public K lastKey() {
        return this.getForwardMap().lastKey();
    }

    @Override
    protected SortedMap<K, V> getForwardMap() {
        return (SortedMap)super.getForwardMap();
    }

    @Override
    protected SortedMap<V, K> getReverseMap() {
        return (SortedMap)super.getReverseMap();
    }

    protected class SortedSubMapDecorator
    extends AbstractMap<K, V>
    implements SortedMap<K, V> {
        protected final SortedMap<K, V> m_oSubMap;

        protected SortedSubMapDecorator(SortedMap<K, V> oSubMap) {
            this.m_oSubMap = oSubMap;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new DualBidiMap.DualBidiEntrySet(this.m_oSubMap.entrySet());
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return new SortedSubMapDecorator(this.m_oSubMap.headMap(toKey));
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return new SortedSubMapDecorator(this.m_oSubMap.subMap(fromKey, toKey));
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return new SortedSubMapDecorator(this.m_oSubMap.tailMap(fromKey));
        }

        @Override
        public V put(K key, V value) {
            DualBidiMap.checkValue(value);
            Object oldValue = this.m_oSubMap.put(key, value);
            Object oldKey = DualSortedBidiMap.this.getReverseMap().put(value, key);
            DualSortedBidiMap.this.getForwardMap().remove(oldKey);
            DualSortedBidiMap.this.getReverseMap().remove(oldValue);
            return oldValue;
        }

        @Override
        public void clear() {
            this.m_oSubMap.clear();
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m_oSubMap.comparator();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m_oSubMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.m_oSubMap.containsValue(value);
        }

        @Override
        public K firstKey() {
            return this.m_oSubMap.firstKey();
        }

        @Override
        public V get(Object key) {
            return this.m_oSubMap.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.m_oSubMap.isEmpty();
        }

        @Override
        public K lastKey() {
            return this.m_oSubMap.lastKey();
        }

        @Override
        public int size() {
            return this.m_oSubMap.size();
        }
    }

    protected class InverseDualSortedBidiMap
    extends DualSortedBidiMap<V, K> {
        protected InverseDualSortedBidiMap(SortedMap<V, K> reverseMap, SortedMap<K, V> forwardMap) {
            super(reverseMap, forwardMap);
        }

        @Override
        public SortedBidiMap<K, V> inverseBidiSortedMap() {
            return DualSortedBidiMap.this;
        }
    }
}

