/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;

public class CollectionBuilder<E, T extends Collection<E>> {
    protected final T _internalCollection;

    public static <E, T extends Collection<E>> CollectionBuilder<E, T> create(T internalCollection) {
        return new CollectionBuilder<E, T>(internalCollection);
    }

    public static <E> CollectionBuilder<E, HashSet<E>> createHashSet() {
        return CollectionBuilder.create(new HashSet());
    }

    public static <E> CollectionBuilder<E, TreeSet<E>> createTreeSet() {
        return CollectionBuilder.create(new TreeSet());
    }

    public static <E> CollectionBuilder<E, TreeSet<E>> createTreeSet(Comparator<? super E> comparator) {
        return CollectionBuilder.create(new TreeSet<E>(comparator));
    }

    public CollectionBuilder(T internalCollection) {
        this._internalCollection = internalCollection;
    }

    public CollectionBuilder<E, T> add(E e) {
        this._internalCollection.add(e);
        return this;
    }

    public CollectionBuilder<E, T> addAll(Collection<? extends E> c) {
        this._internalCollection.addAll(c);
        return this;
    }

    public CollectionBuilder<E, T> addAll(E ... elements) {
        return this.addAll((Collection<? extends E>)Arrays.asList(elements));
    }

    public CollectionBuilder<E, T> remove(Object o) {
        this._internalCollection.remove(o);
        return this;
    }

    public CollectionBuilder<E, T> removeAll(Collection<?> c) {
        this._internalCollection.removeAll(c);
        return this;
    }

    public CollectionBuilder<E, T> removeAll(E ... elements) {
        return this.removeAll((Collection<?>)Arrays.asList(elements));
    }

    public CollectionBuilder<E, T> retainAll(Collection<?> c) {
        this._internalCollection.retainAll(c);
        return this;
    }

    public CollectionBuilder<E, T> retainAll(E ... elements) {
        return this.retainAll((Collection<?>)Arrays.asList(elements));
    }

    public CollectionBuilder<E, T> clear() {
        this._internalCollection.clear();
        return this;
    }

    public T toCollection() {
        return this._internalCollection;
    }

    public String toString() {
        return this._internalCollection.toString();
    }
}

