/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.javagimmicks.collections.builder.CollectionBuilder;

public class ListBuilder<E, T extends List<E>>
extends CollectionBuilder<E, T> {
    public static <E, T extends List<E>> ListBuilder<E, T> create(T internalList) {
        return new ListBuilder<E, T>(internalList);
    }

    public static <E> ListBuilder<E, ArrayList<E>> createArrayList() {
        return ListBuilder.create(new ArrayList());
    }

    public static <E> ListBuilder<E, ArrayList<E>> createArrayList(int initialCapcity) {
        return ListBuilder.create(new ArrayList(initialCapcity));
    }

    public static <E> ListBuilder<E, LinkedList<E>> createLinkedList() {
        return ListBuilder.create(new LinkedList());
    }

    public ListBuilder(T internalList) {
        super(internalList);
    }

    public ListBuilder<E, T> add(int index, E e) {
        ((List)this._internalCollection).add(index, e);
        return this;
    }

    public ListBuilder<E, T> addAll(int index, Collection<? extends E> c) {
        ((List)this._internalCollection).addAll(index, c);
        return this;
    }

    public ListBuilder<E, T> addAll(int index, E ... elements) {
        return this.addAll(Arrays.asList(elements));
    }

    public ListBuilder<E, T> remove(int index) {
        ((List)this._internalCollection).remove(index);
        return this;
    }

    public ListBuilder<E, T> set(int index, E e) {
        ((List)this._internalCollection).set(index, e);
        return this;
    }

    @Override
    public ListBuilder<E, T> add(E e) {
        return (ListBuilder)super.add(e);
    }

    @Override
    public ListBuilder<E, T> addAll(Collection<? extends E> c) {
        return (ListBuilder)super.addAll(c);
    }

    @Override
    public ListBuilder<E, T> addAll(E ... elements) {
        return (ListBuilder)super.addAll(elements);
    }

    @Override
    public ListBuilder<E, T> clear() {
        return (ListBuilder)super.clear();
    }

    @Override
    public ListBuilder<E, T> remove(Object o) {
        return (ListBuilder)super.remove(o);
    }

    @Override
    public ListBuilder<E, T> removeAll(Collection<?> c) {
        return (ListBuilder)super.removeAll(c);
    }

    @Override
    public ListBuilder<E, T> removeAll(E ... elements) {
        return (ListBuilder)super.removeAll(elements);
    }

    @Override
    public ListBuilder<E, T> retainAll(Collection<?> c) {
        return (ListBuilder)super.retainAll(c);
    }

    @Override
    public ListBuilder<E, T> retainAll(E ... elements) {
        return (ListBuilder)super.retainAll(elements);
    }

    public T toList() {
        return (T)((List)this.toCollection());
    }
}

