/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.builder;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class MapBuilder<K, V, T extends Map<K, V>> {
    protected final T _internalMap;

    public static <K, V, T extends Map<K, V>> MapBuilder<K, V, T> create(T internalMap) {
        return new MapBuilder<K, V, T>(internalMap);
    }

    public static <K, V> MapBuilder<K, V, HashMap<K, V>> createHashMap() {
        return MapBuilder.create(new HashMap());
    }

    public static <K, V> MapBuilder<K, V, TreeMap<K, V>> createTreeMap() {
        return MapBuilder.create(new TreeMap());
    }

    public static <K, V> MapBuilder<K, V, TreeMap<K, V>> createTreeMap(Comparator<? super K> comparator) {
        return MapBuilder.create(new TreeMap(comparator));
    }

    public MapBuilder(T internalMap) {
        this._internalMap = internalMap;
    }

    public MapBuilder<K, V, T> put(K key, V value) {
        this._internalMap.put(key, value);
        return this;
    }

    public MapBuilder<K, V, T> putAll(Map<? extends K, ? extends V> map) {
        this._internalMap.putAll(map);
        return this;
    }

    public MapBuilder<K, V, T> remove(Object key) {
        this._internalMap.remove(key);
        return this;
    }

    public MapBuilder<K, V, T> clear() {
        this._internalMap.clear();
        return this;
    }

    public T toMap() {
        return this._internalMap;
    }

    public String toString() {
        return this._internalMap.toString();
    }
}

