/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.composite;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class CompositeEnumeration<E>
implements Enumeration<E> {
    protected final Iterator<Enumeration<E>> _enumerations;
    protected Enumeration<E> _currentEnumeration;
    protected Enumeration<E> _nextEnumeration;

    CompositeEnumeration(List<Enumeration<E>> enumerations) {
        this._enumerations = enumerations.iterator();
        this.findNextEnumeration();
    }

    @Override
    public boolean hasMoreElements() {
        if (this._currentEnumeration != null && this._currentEnumeration.hasMoreElements()) {
            return true;
        }
        this.findNextEnumeration();
        return this._nextEnumeration != null && this._nextEnumeration.hasMoreElements();
    }

    @Override
    public E nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        return this.moveNext();
    }

    protected void findNextEnumeration() {
        if (this._nextEnumeration != null) {
            return;
        }
        while (this._enumerations.hasNext()) {
            this._nextEnumeration = this._enumerations.next();
            if (!this._nextEnumeration.hasMoreElements()) continue;
            break;
        }
    }

    protected E moveNext() {
        if (this._nextEnumeration != null) {
            this._currentEnumeration = this._nextEnumeration;
            this._nextEnumeration = null;
        }
        return this._currentEnumeration.nextElement();
    }
}

