/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.javagimmicks.collections.transformer.Transformer;
import net.sf.javagimmicks.collections.transformer.TransformerUtils15;

class CompositeIterator<E>
implements Iterator<E> {
    protected final Iterator<? extends Iterator<E>> _iterators;
    protected Iterator<E> _currentIterator;
    protected Iterator<E> _nextIterator;

    CompositeIterator(List<? extends Iterator<E>> iterators) {
        this._iterators = iterators.iterator();
        this.findNextIterator();
    }

    static <E, C extends Collection<E>> CompositeIterator<E> fromCollectionList(List<C> collections) {
        Transformer iteratorExtractor = new Transformer<C, Iterator<E>>(){

            @Override
            public Iterator<E> transform(C source) {
                return source.iterator();
            }
        };
        ArrayList iteratorList = new ArrayList(TransformerUtils15.decorate(collections, iteratorExtractor));
        return new CompositeIterator<E>(iteratorList);
    }

    @Override
    public boolean hasNext() {
        if (this._currentIterator != null && this._currentIterator.hasNext()) {
            return true;
        }
        this.findNextIterator();
        return this._nextIterator != null && this._nextIterator.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.moveNext();
    }

    @Override
    public void remove() {
        if (this._currentIterator == null) {
            throw new IllegalStateException();
        }
        this._currentIterator.remove();
    }

    protected void findNextIterator() {
        if (this._nextIterator != null) {
            return;
        }
        while (this._iterators.hasNext()) {
            this._nextIterator = this._iterators.next();
            if (!this._nextIterator.hasNext()) continue;
            break;
        }
    }

    protected E moveNext() {
        if (this._nextIterator != null) {
            this._currentIterator = this._nextIterator;
            this._nextIterator = null;
        }
        return this._currentIterator.next();
    }
}

