/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.composite;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.sf.javagimmicks.collections.transformer.Transformer;

class CompositeListIterator<E>
implements ListIterator<E> {
    protected final ListIterator<? extends ListIterator<E>> _iterators;
    protected ListIterator<E> _previousIterator;
    protected ListIterator<E> _currentIterator;
    protected ListIterator<E> _nextIterator;
    protected int _index;

    CompositeListIterator(List<? extends ListIterator<E>> iterators) {
        this._index = -1;
        this._iterators = iterators.listIterator();
    }

    CompositeListIterator(List<? extends List<E>> lists, int startIndex) {
        this._index = startIndex - 1;
        ArrayList<ListIterator<E>> iteratorList = new ArrayList<ListIterator<E>>(lists.size());
        int listIndex = -1;
        ListIterator<List<E>> listsIterator = lists.listIterator();
        while (listsIterator.hasNext()) {
            ListIterator<E> currentListIterator;
            List<E> currentList = listsIterator.next();
            int currentListSize = currentList.size();
            if (startIndex == -1) {
                currentListIterator = currentList.listIterator();
            } else if (currentListSize >= startIndex) {
                currentListIterator = currentList.listIterator(startIndex);
                this._currentIterator = currentListIterator;
                startIndex = -1;
                listIndex = listsIterator.previousIndex();
            } else {
                currentListIterator = currentList.listIterator(currentListSize);
                startIndex -= currentListSize;
            }
            iteratorList.add(currentListIterator);
        }
        this._iterators = iteratorList.listIterator(listIndex);
        this._iterators.next();
    }

    @Override
    public boolean hasPrevious() {
        if (this._currentIterator != null && this._currentIterator.hasPrevious()) {
            return true;
        }
        this.findPreviousIterator();
        return this._previousIterator != null && this._previousIterator.hasPrevious();
    }

    @Override
    public boolean hasNext() {
        if (this._currentIterator != null && this._currentIterator.hasNext()) {
            return true;
        }
        this.findNextIterator();
        return this._nextIterator != null && this._nextIterator.hasNext();
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.movePrevious();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.moveNext();
    }

    @Override
    public int previousIndex() {
        return this._index;
    }

    @Override
    public int nextIndex() {
        return this._index + 1;
    }

    @Override
    public void remove() {
        if (this._currentIterator == null) {
            throw new IllegalStateException();
        }
        this._currentIterator.remove();
    }

    @Override
    public void add(E e) {
        if (this._currentIterator == null) {
            throw new IllegalStateException();
        }
        this._currentIterator.add(e);
    }

    @Override
    public void set(E e) {
        if (this._currentIterator == null) {
            throw new IllegalStateException();
        }
        this._currentIterator.set(e);
    }

    protected void findPreviousIterator() {
        if (this._previousIterator != null) {
            return;
        }
        while (this._iterators.hasPrevious()) {
            this._previousIterator = this._iterators.previous();
            if (!this._previousIterator.hasPrevious()) continue;
            break;
        }
    }

    protected void findNextIterator() {
        if (this._nextIterator != null) {
            return;
        }
        while (this._iterators.hasNext()) {
            this._nextIterator = this._iterators.next();
            if (!this._nextIterator.hasNext()) continue;
            break;
        }
    }

    protected E movePrevious() {
        if (this._previousIterator != null) {
            this._currentIterator = this._previousIterator;
            this._previousIterator = null;
        }
        --this._index;
        return this._currentIterator.previous();
    }

    protected E moveNext() {
        if (this._nextIterator != null) {
            this._currentIterator = this._nextIterator;
            this._nextIterator = null;
        }
        ++this._index;
        return this._currentIterator.next();
    }

    static class ListIteratorExtractor<E, C extends List<E>>
    implements Transformer<C, ListIterator<E>> {
        ListIteratorExtractor() {
        }

        @Override
        public ListIterator<E> transform(C source) {
            return source.listIterator();
        }
    }
}

