/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.collections.diff;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import net.sf.javagimmicks.collections.diff.DefaultDifference;
import net.sf.javagimmicks.collections.diff.DefaultDifferenceList;
import net.sf.javagimmicks.collections.diff.DifferenceList;

class DifferenceAlgorithm<T> {
    protected final List<T> _fromList;
    protected final List<T> _toList;
    protected final Comparator<T> _comparator;
    protected final DifferenceList<T> _differences = new DefaultDifferenceList();
    protected DefaultDifference<T> _pending;

    protected DifferenceAlgorithm(List<T> fromList, List<T> toList, Comparator<T> comparator) {
        this._fromList = fromList;
        this._toList = toList;
        this._comparator = comparator;
        this.traverseSequences();
        if (this._pending != null) {
            this._differences.add(this._pending);
        }
    }

    public DifferenceList<T> getDifferences() {
        return this._differences;
    }

    protected void traverseSequences() {
        int indexA;
        List<Integer> matches = this.getLongestCommonSubsequences();
        int lastIndexA = this._fromList.size() - 1;
        int lastIndexB = this._toList.size() - 1;
        int indexB = 0;
        int lastMatchIndex = matches.size() - 1;
        for (indexA = 0; indexA <= lastMatchIndex; ++indexA) {
            Integer bLine = matches.get(indexA);
            if (bLine == null) {
                this.onANotB(indexA, indexB);
                continue;
            }
            while (indexB < bLine) {
                this.onBNotA(indexA, indexB++);
            }
            this.onMatch(indexA, indexB++);
        }
        boolean calledFinishA = false;
        boolean calledFinishB = false;
        while (indexA <= lastIndexA || indexB <= lastIndexB) {
            if (indexA == lastIndexA + 1 && indexB <= lastIndexB) {
                if (!calledFinishA && this.callFinishedA()) {
                    this.finishedA(lastIndexA);
                    calledFinishA = true;
                } else {
                    while (indexB <= lastIndexB) {
                        this.onBNotA(indexA, indexB++);
                    }
                }
            }
            if (indexB == lastIndexB + 1 && indexA <= lastIndexA) {
                if (!calledFinishB && this.callFinishedB()) {
                    this.finishedB(lastIndexB);
                    calledFinishB = true;
                } else {
                    while (indexA <= lastIndexA) {
                        this.onANotB(indexA++, indexB);
                    }
                }
            }
            if (indexA <= lastIndexA) {
                this.onANotB(indexA++, indexB);
            }
            if (indexB > lastIndexB) continue;
            this.onBNotA(indexA, indexB++);
        }
    }

    protected boolean callFinishedA() {
        return false;
    }

    protected boolean callFinishedB() {
        return false;
    }

    protected void finishedA(int lastA) {
    }

    protected void finishedB(int lastB) {
    }

    protected void onANotB(int indexA, int indexB) {
        if (this._pending == null) {
            this._pending = new DefaultDifference();
            this._pending.setDeleteStartIndex(indexA);
            this._pending.setDeleteEndIndex(indexA);
            this._pending.setAddStartIndex(indexB);
            this._pending.setFromList(this._fromList);
            this._pending.setToList(this._toList);
        } else {
            DifferenceAlgorithm.setDeleted(this._pending, indexA);
        }
    }

    protected void onBNotA(int indexA, int indexB) {
        if (this._pending == null) {
            this._pending = new DefaultDifference();
            this._pending.setDeleteStartIndex(indexA);
            this._pending.setAddStartIndex(indexB);
            this._pending.setAddEndIndex(indexB);
            this._pending.setFromList(this._fromList);
            this._pending.setToList(this._toList);
        } else {
            DifferenceAlgorithm.setAdded(this._pending, indexB);
        }
    }

    protected void onMatch(int indexA, int indexB) {
        if (this._pending != null) {
            this._differences.add(this._pending);
            this._pending = null;
        }
    }

    protected boolean equals(T x, T y) {
        if (this._comparator == null) {
            if (x instanceof Comparable) {
                return ((Comparable)x).compareTo(y) == 0;
            }
            return x.equals(y);
        }
        return this._comparator.compare(x, y) == 0;
    }

    protected List<Integer> getLongestCommonSubsequences() {
        int startIndexA = 0;
        int endIndexA = this._fromList.size() - 1;
        int startIndexB = 0;
        int endIndexB = this._toList.size() - 1;
        TreeMap<Integer, Integer> matches = new TreeMap<Integer, Integer>();
        while (startIndexA <= endIndexA && startIndexB <= endIndexB && this.equals(this._fromList.get(startIndexA), this._toList.get(startIndexB))) {
            matches.put(startIndexA++, startIndexB++);
        }
        while (startIndexA <= endIndexA && startIndexB <= endIndexB && this.equals(this._fromList.get(endIndexA), this._toList.get(endIndexB))) {
            matches.put(endIndexA--, endIndexB--);
        }
        AbstractMap bMatches = this._comparator == null ? (this._fromList.get(0) instanceof Comparable ? new TreeMap() : new HashMap()) : new TreeMap(this._comparator);
        for (int indexB = startIndexB; indexB <= endIndexB; ++indexB) {
            T key = this._toList.get(indexB);
            ArrayList<Integer> positions = (ArrayList<Integer>)bMatches.get(key);
            if (positions == null) {
                positions = new ArrayList<Integer>();
                bMatches.put(key, positions);
            }
            positions.add(indexB);
        }
        TreeMap<Integer, Integer> thresh = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Link> links = new TreeMap<Integer, Link>();
        for (int indexA = startIndexA; indexA <= endIndexA; ++indexA) {
            T key = this._fromList.get(indexA);
            List positions = (List)bMatches.get(key);
            if (positions == null) continue;
            Integer k = 0;
            ListIterator positionIter = positions.listIterator(positions.size());
            while (positionIter.hasPrevious()) {
                Integer j = (Integer)positionIter.previous();
                k = this.insert(thresh, j, k);
                if (k == null) continue;
                Link value = k > 0 ? (Link)links.get(k - 1) : null;
                links.put(k, new Link(value, indexA, j));
            }
        }
        if (!thresh.isEmpty()) {
            Link link = (Link)links.get(thresh.lastKey());
            while (link != null) {
                matches.put(link._x, link._y);
                link = link._link;
            }
        }
        return DifferenceAlgorithm.toList(matches);
    }

    protected static List<Integer> toList(TreeMap<Integer, Integer> map) {
        Integer[] result = new Integer[map.size() == 0 ? 0 : 1 + map.lastKey()];
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            result[entry.getKey().intValue()] = entry.getValue();
        }
        return Arrays.asList(result);
    }

    protected static boolean isNonzero(Integer i) {
        return i != null && i != 0;
    }

    protected boolean isGreaterThan(TreeMap<Integer, Integer> thresh, Integer index, Integer val) {
        Integer lhs = thresh.get(index);
        return lhs != null && val != null && lhs > val;
    }

    protected boolean isLessThan(TreeMap<Integer, Integer> thresh, Integer index, Integer val) {
        Integer lhs = thresh.get(index);
        return lhs != null && (val == null || lhs < val);
    }

    protected void append(TreeMap<Integer, Integer> thresh, Integer value) {
        int addIdx = thresh.isEmpty() ? 0 : thresh.lastKey() + 1;
        thresh.put(addIdx, value);
    }

    protected Integer insert(TreeMap<Integer, Integer> thresh, Integer j, Integer k) {
        if (DifferenceAlgorithm.isNonzero(k) && this.isGreaterThan(thresh, k, j) && this.isLessThan(thresh, k - 1, j)) {
            thresh.put(k, j);
        } else {
            int highIndex = -1;
            if (DifferenceAlgorithm.isNonzero(k)) {
                highIndex = k;
            } else if (!thresh.isEmpty()) {
                highIndex = thresh.lastKey();
            }
            if (highIndex == -1 || j.compareTo(thresh.get(thresh.lastKey())) > 0) {
                this.append(thresh, j);
                k = highIndex + 1;
            } else {
                int lowIndex = 0;
                while (lowIndex <= highIndex) {
                    int index = (highIndex + lowIndex) / 2;
                    Integer val = thresh.get(index);
                    int compareResult = j.compareTo(val);
                    if (compareResult == 0) {
                        return null;
                    }
                    if (compareResult > 0) {
                        lowIndex = index + 1;
                        continue;
                    }
                    highIndex = index - 1;
                }
                thresh.put(lowIndex, j);
                k = lowIndex;
            }
        }
        return k;
    }

    protected static void setDeleted(DefaultDifference<?> d, int index) {
        d.setDeleteStartIndex(Math.min(index, d.getDeleteStartIndex()));
        d.setDeleteEndIndex(Math.max(index, d.getDeleteEndIndex()));
    }

    protected static void setAdded(DefaultDifference<?> d, int index) {
        d.setAddStartIndex(Math.min(index, d.getAddStartIndex()));
        d.setAddEndIndex(Math.max(index, d.getAddEndIndex()));
    }

    protected static class Link {
        public final Link _link;
        public final Integer _x;
        public final Integer _y;

        protected Link(Link link, Integer x, Integer y) {
            this._link = link;
            this._x = x;
            this._y = y;
        }
    }
}

